export const getPluginKey = plugin => {
  if (typeof plugin === 'string') {
    return plugin;
  }
  if (Array.isArray(plugin)) {
    return getPluginKey(plugin[0]);
  }
  if (typeof plugin === 'object' && plugin !== null && 'key' in plugin) {
    return plugin.key ?? null;
  }
  return null;
};
//# sourceMappingURL=getPluginKey.js.map