"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadYamlConfig = void 0;
const yaml_1 = __importDefault(require("yaml"));
const lodash_1 = require("lodash");
const utils_fs_1 = require("@ionic/utils-fs");
const cli_1 = require("./util/cli");
const ctx_1 = require("./ctx");
const colors_1 = __importDefault(require("./colors"));
const ctx_2 = require("./ctx");
const log_1 = require("./util/log");
async function loadYamlConfig(ctx, filename) {
    const contents = await (0, utils_fs_1.readFile)(filename, { encoding: 'utf-8' });
    const parsed = yaml_1.default.parse(contents, {
        prettyErrors: true,
    });
    if (!parsed) {
        (0, log_1.warn)('Empty config file, exiting...');
        process.exit(0);
    }
    await (0, ctx_2.initVarsFromEnv)(ctx, parsed.vars);
    await ensureVars(ctx, parsed);
    const resolved = interpolateVars(ctx, parsed);
    return resolved;
}
exports.loadYamlConfig = loadYamlConfig;
async function ensureVars(ctx, yaml) {
    const { vars } = yaml;
    for (const v in vars) {
        const vk = vars[v] || {};
        if (!vk || (typeof ctx.vars[v] === 'undefined' && typeof vk.default === 'undefined')) {
            const answers = await (0, cli_1.logPrompt)(`Required variable: ${colors_1.default.strong(v)}\n` +
                (vk.description
                    ? `${colors_1.default.strong('Description:')} ${vk.description}`
                    : ''), {
                type: 'text',
                name: 'value',
                message: `${v} =`,
                validate: (input) => !!input,
            });
            if (answers.value) {
                ctx.vars[v] = {
                    value: answers.value,
                };
            }
        }
    }
}
function interpolateVars(ctx, yaml) {
    const { vars } = yaml;
    for (let k in vars) {
        const v = vars[k];
        if (v && typeof v.default !== 'undefined') {
            v.value = v.default;
        }
    }
    ctx.vars = {
        ...vars,
        ...ctx.vars,
    };
    return interpolateVarsInTree(ctx, yaml);
}
function interpolateVarsInTree(ctx, yaml) {
    const newObject = (0, lodash_1.clone)(yaml);
    (0, lodash_1.each)(yaml, (val, key) => {
        if (typeof val === 'string') {
            const interped = (0, ctx_1.str)(ctx, val);
            if (typeof interped === 'object') {
                // Recur into the new object value to interp any sub-fields
                newObject[key] = interpolateVarsInTree(ctx, interped);
            }
            else {
                newObject[key] = interped;
            }
        }
        else if (typeof val === 'object' || Array.isArray(val)) {
            newObject[key] = interpolateVarsInTree(ctx, val);
        }
    });
    return newObject;
}
//# sourceMappingURL=yaml-config.js.map