# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

# [7.2.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@7.1.6...@ionic/cli@7.2.0) (2024-01-02)


### Bug Fixes

* live reload deploys app when warnings are present [#4807](https://github.com/ionic-team/ionic-cli/issues/4807) ([#5043](https://github.com/ionic-team/ionic-cli/issues/5043)) ([ef5706e](https://github.com/ionic-team/ionic-cli/commit/ef5706ed5e7ef347280320a88b5604a279667184))


### Features

* **angular:** support angulars vite dev server ([#5064](https://github.com/ionic-team/ionic-cli/issues/5064)) ([8a94434](https://github.com/ionic-team/ionic-cli/commit/8a94434a413c1b60b0e88904064edfe7a98206ab))





## [7.1.6](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@7.1.5...@ionic/cli@7.1.6) (2023-12-19)


### Bug Fixes

* **cli:** resolve vm2 security vulnerability ([#5070](https://github.com/ionic-team/ionic-cli/issues/5070)) ([4050419](https://github.com/ionic-team/ionic-cli/commit/4050419bef70fb92e58b0a83cd4b68b48090e596))





## [7.1.5](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@7.1.4...@ionic/cli@7.1.5) (2023-11-08)


### Bug Fixes

* use native ES2022 error cause ([#5010](https://github.com/ionic-team/ionic-cli/issues/5010)) ([d19f28e](https://github.com/ionic-team/ionic-cli/commit/d19f28e3f41b8f0248c11c49b7006754bb315218))





## [7.1.4](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@7.1.3...@ionic/cli@7.1.4) (2023-11-08)


### Reverts

* use native ES2022 error cause ([#5060](https://github.com/ionic-team/ionic-cli/issues/5060)) ([1e64a1a](https://github.com/ionic-team/ionic-cli/commit/1e64a1ada60545adf8e7c99fbd1f8766cf2416f9))





## [7.1.3](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@7.1.2...@ionic/cli@7.1.3) (2023-11-07)

**Note:** Version bump only for package @ionic/cli





## [7.1.2](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@7.1.1...@ionic/cli@7.1.2) (2023-11-07)


### Bug Fixes

* use native ES2022 error cause ([#5010](https://github.com/ionic-team/ionic-cli/issues/5010)) ([0c4cd0f](https://github.com/ionic-team/ionic-cli/commit/0c4cd0f47e00b43e8c0ce4eef072351a846b566c))





## [7.1.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@7.1.0...@ionic/cli@7.1.1) (2023-05-02)

**Note:** Version bump only for package @ionic/cli





# [7.1.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@7.0.1...@ionic/cli@7.1.0) (2023-05-01)


### Features

* add standalone as an option ([#5005](https://github.com/ionic-team/ionic-cli/issues/5005)) ([707a42d](https://github.com/ionic-team/ionic-cli/commit/707a42d29579a355d9a57b65c07ec6a0b681028e))





## [7.0.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@7.0.0...@ionic/cli@7.0.1) (2023-04-05)


### Bug Fixes

* state should not be required on OAuth Response ([#4995](https://github.com/ionic-team/ionic-cli/issues/4995)) ([c053cb3](https://github.com/ionic-team/ionic-cli/commit/c053cb3394acec5402d2ea436796775d67c98d39))
* **cli:** ionic info returns package information ([#4991](https://github.com/ionic-team/ionic-cli/issues/4991)) ([2dd9136](https://github.com/ionic-team/ionic-cli/commit/2dd9136bb85375b03883105d04d1c1bb090d884d)), closes [#4992](https://github.com/ionic-team/ionic-cli/issues/4992)





# [7.0.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.20.9...@ionic/cli@7.0.0) (2023-03-29)


### Bug Fixes

* update test to reflect new output ([#4967](https://github.com/ionic-team/ionic-cli/issues/4967)) ([5c23518](https://github.com/ionic-team/ionic-cli/commit/5c23518b1a7bda4f020a82ced5557e157ccdbbc7))


### chore

* **appflow:** remove appflow from @ionic/cli ([#4777](https://github.com/ionic-team/ionic-cli/issues/4777)) ([34b07ad](https://github.com/ionic-team/ionic-cli/commit/34b07ad4b53130057ecc5a736036a87d582744c2))


### Code Refactoring

* **docs:** remove ionic docs command ([#4969](https://github.com/ionic-team/ionic-cli/issues/4969)) ([e624258](https://github.com/ionic-team/ionic-cli/commit/e62425889d07b496c0e578b61413ab00a8dae8d3))
* **doctor:** remove ionic doctor command ([#4959](https://github.com/ionic-team/ionic-cli/issues/4959)) ([13568b1](https://github.com/ionic-team/ionic-cli/commit/13568b138bb8007e91901820656e97ac121a4913))
* **lab:** remove ionic serve --lab option ([#4960](https://github.com/ionic-team/ionic-cli/issues/4960)) ([d6512a5](https://github.com/ionic-team/ionic-cli/commit/d6512a5139943dbe2084f99e63075db6e6b15b4d))


### Features

* add vite support for react and vue ([#4966](https://github.com/ionic-team/ionic-cli/issues/4966)) ([94e9fa2](https://github.com/ionic-team/ionic-cli/commit/94e9fa2a2146883ad857d2acad71b7605e3687d0))
* remove ionic-angular project type ([ff1c936](https://github.com/ionic-team/ionic-cli/commit/ff1c93635a74fc26e57319123118eaf3ce6d9958))
* remove ionicv1 project type ([6ea2d48](https://github.com/ionic-team/ionic-cli/commit/6ea2d48da10d2b964ab95961cc9600874279c59d))
* remove v3 and v1 integrations ([d40da3d](https://github.com/ionic-team/ionic-cli/commit/d40da3d07da909f82807fe7182c035c69d20a65c))
* use vite specific projects for starters ([#4970](https://github.com/ionic-team/ionic-cli/issues/4970)) ([f35ea72](https://github.com/ionic-team/ionic-cli/commit/f35ea7239d5b23f819084691480f1c791377d55f))


### BREAKING CHANGES

* **appflow:** The `package` commands and the `deploy build` command have been removed. Developers should migrate to the Ionic Cloud CLI instead. 
- Using `deploy build`? Migrate to ionic-cloud build web and if you used the -channel option, also use ionic-cloud deploy web.
- Using `package` commands? Migrate to ionic-cloud build and ionic-cloud deploy.

The remaining `deploy` commands have been renamed to `live-update`.

| deploy command | live-update command |
| - | - |
| `ionic deploy add` | `ionic live-update add` |
| `ionic deploy configure` | `ionic live-update configure` |
| `ionic deploy manifest` | `ionic live-update manifest` |

See https://ionic.io/docs/appflow/cli/overview for more information on the Ionic Cloud CLI.
* **docs:** The `ionic docs` command has been removed. See https://github.com/ionic-team/ionic-cli/pull/4905 for an alternative.
* **doctor:** The `ionic doctor` command has been removed. See https://github.com/ionic-team/ionic-cli/pull/4907 for alternatives.
* **lab:** The `--lab` option has been removed from `ionic serve`. See https://ionicframework.com/docs/developing/previewing for alternatives.
* This commit removes integrations with V1 and V3 Ionic
project types
* This commit removes the Ionic V1 project type from the
available project integrations. Please migrate to a modern Ionic
project.
* Integration with V3 (aka ionic-angular) project has
been removed. Please update to modern Ionic projects.





## [6.20.9](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.20.8...@ionic/cli@6.20.9) (2023-03-17)


### Bug Fixes

* **cli:** native solution preview should no longer be hidden ([#4962](https://github.com/ionic-team/ionic-cli/issues/4962)) ([a2eb4b2](https://github.com/ionic-team/ionic-cli/commit/a2eb4b2cf46e0f2004c1850acfdeada46fb211b5))





## [6.20.9](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.20.8...@ionic/cli@6.20.9) (2023-03-17)


### Bug Fixes

* **cli:** native solution preview should no longer be hidden ([#4962](https://github.com/ionic-team/ionic-cli/issues/4962)) ([a2eb4b2](https://github.com/ionic-team/ionic-cli/commit/a2eb4b2cf46e0f2004c1850acfdeada46fb211b5))





## [6.20.8](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.20.7...@ionic/cli@6.20.8) (2023-01-13)

**Note:** Version bump only for package @ionic/cli





## [6.20.7](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.20.7...@ionic/cli@6.20.7) (2023-01-13)

**Note:** Version bump only for package @ionic/cli





## [6.20.7](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.20.6...@ionic/cli@6.20.7) (2023-01-13)


### Bug Fixes

* **capacitor:** forward --inline to Capacitor CLI on copy and sync ([#4928](https://github.com/ionic-team/ionic-cli/issues/4928)) ([f5f75fa](https://github.com/ionic-team/ionic-cli/commit/f5f75fa27cffee37571813a2827cfc02baf0cb9a))
* **cli:** Deprecate doctor and lab commands ([#4945](https://github.com/ionic-team/ionic-cli/issues/4945)) ([6fcf882](https://github.com/ionic-team/ionic-cli/commit/6fcf882b9ee9c31fcea38a6390b3c181c4df5ca6))
* deploy manifest error if no capacitor CLI ([#4940](https://github.com/ionic-team/ionic-cli/issues/4940)) ([f586a18](https://github.com/ionic-team/ionic-cli/commit/f586a18805ead288850f18d8981db4f0ad8848ed))





## [6.20.6](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.20.5...@ionic/cli@6.20.6) (2022-12-20)


### Bug Fixes

* **cli:** capacitor recognize multi-project ([#4937](https://github.com/ionic-team/ionic-cli/issues/4937)) ([553ea79](https://github.com/ionic-team/ionic-cli/commit/553ea794f916f17db131d359caba9b6c1b31b919))





## [6.20.5](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.20.4...@ionic/cli@6.20.5) (2022-12-13)

**Note:** Version bump only for package @ionic/cli





## [6.20.4](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.20.3...@ionic/cli@6.20.4) (2022-11-15)


### Bug Fixes

* **capacitor:** Error if no emulators or devices are found on run ([#4931](https://github.com/ionic-team/ionic-cli/issues/4931)) ([7ec24c0](https://github.com/ionic-team/ionic-cli/commit/7ec24c04043b760ff9940d24c9ac281dce3aa21f))





## [6.20.3](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.20.2...@ionic/cli@6.20.3) (2022-10-06)


### Bug Fixes

* **cli:** capacitor commands not working ([#4918](https://github.com/ionic-team/ionic-cli/issues/4918)) ([27b958b](https://github.com/ionic-team/ionic-cli/commit/27b958bdf22c37f962d705a1b8ba1fee78b59c42))





## [6.20.2](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.20.1...@ionic/cli@6.20.2) (2022-09-29)


### Bug Fixes

* **cli:** capacitor config not being read from multi-project directories ([#4909](https://github.com/ionic-team/ionic-cli/issues/4909)) ([0ab4881](https://github.com/ionic-team/ionic-cli/commit/0ab4881736f0d3b967d12802cb9cd01ba24d2088))





## [6.20.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.20.0...@ionic/cli@6.20.1) (2022-06-21)

**Note:** Version bump only for package @ionic/cli





# [6.20.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.19.1...@ionic/cli@6.20.0) (2022-06-16)


### Bug Fixes

* **integrations:** Move ng add @ionic/cordova-builders after package installs ([#4853](https://github.com/ionic-team/ionic-cli/issues/4853)) ([8a69ae0](https://github.com/ionic-team/ionic-cli/commit/8a69ae0fd7d7fc15a0d1d5107199299117d34af4))


### Features

* **capacitor:** enable NSAppTransportSecurity settings for live reload if needed ([#4851](https://github.com/ionic-team/ionic-cli/issues/4851)) ([24e22a6](https://github.com/ionic-team/ionic-cli/commit/24e22a60d17709ff78563a796db01e69b6d641cb))
* **cli:** allow cap electron commands ([#4854](https://github.com/ionic-team/ionic-cli/issues/4854)) ([46da22f](https://github.com/ionic-team/ionic-cli/commit/46da22ff5b89c66155829a307acd765c5ff957d0))





## [6.19.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.19.0...@ionic/cli@6.19.1) (2022-05-09)


### Bug Fixes

* **capacitor:** Match platform version with CLI version ([#4829](https://github.com/ionic-team/ionic-cli/issues/4829)) ([9846d46](https://github.com/ionic-team/ionic-cli/commit/9846d467e926e76232826175d3d0d50c00b1ef1f))
* **vue:** pass extra args to vue-cli serve ([#4827](https://github.com/ionic-team/ionic-cli/issues/4827)) ([87a0dcd](https://github.com/ionic-team/ionic-cli/commit/87a0dcdfd9f75b91e83c0eb13761d6135b226212))





# [6.19.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.18.2...@ionic/cli@6.19.0) (2022-03-15)


### Features

* **integrations:** add ng add cordova-builder ([#4823](https://github.com/ionic-team/ionic-cli/issues/4823)) ([de8d028](https://github.com/ionic-team/ionic-cli/commit/de8d028f54199ddd59aed6636378e4829875a0cd))





## [6.18.2](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.18.1...@ionic/cli@6.18.2) (2022-03-04)


### Bug Fixes

* Pin @types/superagent version to avoid build problems ([#4802](https://github.com/ionic-team/ionic-cli/issues/4802)) ([bdf5b05](https://github.com/ionic-team/ionic-cli/commit/bdf5b05833b92471f4ac5ba24437a8131adbf2e1))





## [6.18.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.18.0...@ionic/cli@6.18.1) (2021-11-10)


### Bug Fixes

* Update superagent-proxy dependency to v3 ([#4779](https://github.com/ionic-team/ionic-cli/issues/4779)) ([f153355](https://github.com/ionic-team/ionic-cli/commit/f153355324a958389f8414d72caa41035ec8bd98))





# [6.18.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.17.1...@ionic/cli@6.18.0) (2021-10-25)


### Bug Fixes

* **vue:** pass extra args to vue-cli ([56dd8a7](https://github.com/ionic-team/ionic-cli/commit/56dd8a7fe94d764bac63a41d35e0b709a2dde893)), closes [#4669](https://github.com/ionic-team/ionic-cli/issues/4669) [#4642](https://github.com/ionic-team/ionic-cli/issues/4642) [#4642](https://github.com/ionic-team/ionic-cli/issues/4642)


### Features

* **appflow:** deprecate appflow functionality in @ionic/cli ([#4776](https://github.com/ionic-team/ionic-cli/issues/4776)) ([6a39641](https://github.com/ionic-team/ionic-cli/commit/6a39641555c9247cc53091db5afde73f9b1d3e34))





## [6.17.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.17.0...@ionic/cli@6.17.1) (2021-09-03)


### Bug Fixes

* support Capacitor 1 apps ([#4758](https://github.com/ionic-team/ionic-cli/issues/4758)) ([0ca282b](https://github.com/ionic-team/ionic-cli/commit/0ca282b615e52867b1cbf263d08472878083f34f))





# [6.17.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.16.3...@ionic/cli@6.17.0) (2021-08-11)


### Bug Fixes

* numeric app names dont crash adding capacitor ([#4709](https://github.com/ionic-team/ionic-cli/issues/4709)) ([e13a4c5](https://github.com/ionic-team/ionic-cli/commit/e13a4c5ebccc79a85334968854688df9ada4b150))
* Remove serve options from cap run command ([#4736](https://github.com/ionic-team/ionic-cli/issues/4736)) ([75e635b](https://github.com/ionic-team/ionic-cli/commit/75e635b6431d186a79ab5ad685ca10798120e38f))


### Features

* Add web based GUI start wizard to ionic start command ([#4746](https://github.com/ionic-team/ionic-cli/issues/4746)) ([c0669a9](https://github.com/ionic-team/ionic-cli/commit/c0669a9d48b3728c485aa19a2d55fedbe582d121))
* Cap is no longer experimental and is default for Angular ([#4745](https://github.com/ionic-team/ionic-cli/issues/4745)) ([d81e08b](https://github.com/ionic-team/ionic-cli/commit/d81e08bee0e2495c97b984dcc69f95c00ade31ab))





## [6.16.3](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.16.2...@ionic/cli@6.16.3) (2021-06-08)


### Bug Fixes

* revert the change to update the lock file when the --no-deps flag is used and issue a warning instead ([#4713](https://github.com/ionic-team/ionic-cli/issues/4713)) ([96ba8b4](https://github.com/ionic-team/ionic-cli/commit/96ba8b40a24a8ba4e4bcfb84aa972e77220fb3d4))





## [6.16.2](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.16.1...@ionic/cli@6.16.2) (2021-06-03)


### Bug Fixes

* Add status-bar to plugins installed on capacitor integration ([#4701](https://github.com/ionic-team/ionic-cli/issues/4701)) ([7c49d5c](https://github.com/ionic-team/ionic-cli/commit/7c49d5cdd717a05eff2e2f2d1fc5f209fd450f43))
* updated `ionic start` to update lock files when the --no-deps arg is passed ([#4706](https://github.com/ionic-team/ionic-cli/issues/4706)) ([868e61d](https://github.com/ionic-team/ionic-cli/commit/868e61d70c54023e39896b677ceac331b0606167))





## [6.16.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.16.0...@ionic/cli@6.16.1) (2021-05-19)


### Bug Fixes

* **capacitor:** Make add use latest instead of next ([#4700](https://github.com/ionic-team/ionic-cli/issues/4700)) ([04be661](https://github.com/ionic-team/ionic-cli/commit/04be661d9ec48960428aa65987c21a5f2bd6951b))





# [6.16.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.15.0...@ionic/cli@6.16.0) (2021-05-19)


### Bug Fixes

* **capacitor:** remove extra logging ([6cebf63](https://github.com/ionic-team/ionic-cli/commit/6cebf631dc3ab2b683da2a9a8fd24787504b88ae))


### Features

* **capacitor:** capacitor 3 support ([#4610](https://github.com/ionic-team/ionic-cli/issues/4610)) ([359cdec](https://github.com/ionic-team/ionic-cli/commit/359cdec031f3c3484093e9fee65e06ef866cfd8b)), closes [#4690](https://github.com/ionic-team/ionic-cli/issues/4690)





# [6.15.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.14.1...@ionic/cli@6.15.0) (2021-05-11)


### Features

* **link:** Link bug fix and git selection changes ([#4689](https://github.com/ionic-team/ionic-cli/issues/4689)) ([942e965](https://github.com/ionic-team/ionic-cli/commit/942e96576f17b9958d4fe0be680235bc22ecbd32))





## [6.14.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.14.0...@ionic/cli@6.14.1) (2021-04-30)


### Bug Fixes

* **appflow:** allow personal accounts to install enterprise packages ([#4681](https://github.com/ionic-team/ionic-cli/issues/4681)) ([97b0ee5](https://github.com/ionic-team/ionic-cli/commit/97b0ee5fa4432f965eabd38089681045dd3a4d5c))





# [6.14.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.13.1...@ionic/cli@6.14.0) (2021-04-28)


### Features

* **appflow:** add flag for skipping artifact download after builds succeed ([#4678](https://github.com/ionic-team/ionic-cli/issues/4678)) ([d87c6f2](https://github.com/ionic-team/ionic-cli/commit/d87c6f28a34c668349868f8214346ff07398c820))





## [6.13.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.13.0...@ionic/cli@6.13.1) (2021-02-22)


### Bug Fixes

* **appflow:** fix deploy manifest for Capacitor 1.x apps ([#4648](https://github.com/ionic-team/ionic-cli/issues/4648)) ([77b02a3](https://github.com/ionic-team/ionic-cli/commit/77b02a39d08fb369c6b95b5f3b0c255370e9fc23))





# [6.13.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.12.4...@ionic/cli@6.13.0) (2021-02-18)


### Bug Fixes

* **appflow:** Default should be all available not hard-coded by platform ([#4645](https://github.com/ionic-team/ionic-cli/issues/4645)) ([6e66109](https://github.com/ionic-team/ionic-cli/commit/6e66109d4993ddb24882bd5c5875a31b2fe65cff))


### Features

* **appflow:** support Capacitor only apps with `ionic deploy manifest` ([#4641](https://github.com/ionic-team/ionic-cli/issues/4641)) ([cee620b](https://github.com/ionic-team/ionic-cli/commit/cee620baff2515115393d882b88f6a99e3fefd9b))
* **appflow:** Support downloading all artifact types from appflow builds ([cae11db](https://github.com/ionic-team/ionic-cli/commit/cae11dba3f1efbec753ae6e91c21ad79be169e38))
* **appflow:** Support downloading WWW_ZIP after deploy build ([bce15d1](https://github.com/ionic-team/ionic-cli/commit/bce15d1b57a102938d4e6922773fe27af24dcca7))





## [6.12.4](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.12.3...@ionic/cli@6.12.4) (2021-01-27)


### Bug Fixes

* **Appflow:** Fix issue with deploy add and deploy configure commands where sometimes necessary variables weren't correctly set. ([#4634](https://github.com/ionic-team/ionic-cli/issues/4634)) ([be6cf2e](https://github.com/ionic-team/ionic-cli/commit/be6cf2e05957b38c35dd692a3917c22c262e5e71))





## [6.12.3](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.12.2...@ionic/cli@6.12.3) (2020-12-10)


### Bug Fixes

* **appflow:** allow download of packages built from branches with  in the name. CT-434 ([#4622](https://github.com/ionic-team/ionic-cli/issues/4622)) ([0054fd5](https://github.com/ionic-team/ionic-cli/commit/0054fd51706c071ffad98bf04ee053266bc780d1))





## [6.12.2](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.12.1...@ionic/cli@6.12.2) (2020-11-17)


### Bug Fixes

* **react:** fix stdin to unblock react-scripts>3.4.0 ([#4609](https://github.com/ionic-team/ionic-cli/issues/4609)) ([47631f5](https://github.com/ionic-team/ionic-cli/commit/47631f5a9331f3bc428933da68c82176221746c6))





## [6.12.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.12.0...@ionic/cli@6.12.1) (2020-10-29)


### Bug Fixes

* **Appflow:** fixes bug when a build that gets cancelled on the dashboard is not recognized as a final state in the CLI ([#4598](https://github.com/ionic-team/ionic-cli/issues/4598)) ([51eab00](https://github.com/ionic-team/ionic-cli/commit/51eab00105a7616df869cd82eea54f1a55b7ab44))





# [6.12.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.11.12...@ionic/cli@6.12.0) (2020-10-15)


### Features

* support vue projects ([#4515](https://github.com/ionic-team/ionic-cli/issues/4515)) ([ad6c483](https://github.com/ionic-team/ionic-cli/commit/ad6c483bd59b4f5e70acac22f456b0b062f4d39c))





## [6.11.12](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.11.11...@ionic/cli@6.11.12) (2020-10-12)


### Bug Fixes

* **capacitor:** use correct root when checking platforms ([e243357](https://github.com/ionic-team/ionic-cli/commit/e2433573bae66210d7ef29d6a2c170faa8abe408))
* **cordova:** load config.xml after serve/build hooks ([9867ada](https://github.com/ionic-team/ionic-cli/commit/9867adafbdd200712a35b38d39c54af6f809c987))





## [6.11.11](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.11.10...@ionic/cli@6.11.11) (2020-10-05)


### Bug Fixes

* **Appflow:** fix bug where appflow build would fail to copy IPA/APK if tmp dir was mounted on a different filesystem ([#4578](https://github.com/ionic-team/ionic-cli/issues/4578)) ([65c740d](https://github.com/ionic-team/ionic-cli/commit/65c740d8ef3195e63d026ac229b7fe8bf1187da6))





## [6.11.10](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.11.9...@ionic/cli@6.11.10) (2020-09-29)

**Note:** Version bump only for package @ionic/cli





## [6.11.9](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.11.8...@ionic/cli@6.11.9) (2020-09-24)


### Bug Fixes

* **cordova:** handle output-metadata.json files during android run ([5905cc1](https://github.com/ionic-team/ionic-cli/commit/5905cc1a9cd75b1a2bb8343da2fbc7146322ad28))





## [6.11.8](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.11.7...@ionic/cli@6.11.8) (2020-09-02)

**Note:** Version bump only for package @ionic/cli





## [6.11.7](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.11.6...@ionic/cli@6.11.7) (2020-08-29)

**Note:** Version bump only for package @ionic/cli





## [6.11.6](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.11.5...@ionic/cli@6.11.6) (2020-08-28)

**Note:** Version bump only for package @ionic/cli





## [6.11.5](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.11.4...@ionic/cli@6.11.5) (2020-08-27)

**Note:** Version bump only for package @ionic/cli





## [6.11.4](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.11.3...@ionic/cli@6.11.4) (2020-08-27)

**Note:** Version bump only for package @ionic/cli





## [6.11.3](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.11.2...@ionic/cli@6.11.3) (2020-08-26)

**Note:** Version bump only for package @ionic/cli





## [6.11.2](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.11.1...@ionic/cli@6.11.2) (2020-08-25)

**Note:** Version bump only for package @ionic/cli





## [6.11.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.11.0...@ionic/cli@6.11.1) (2020-08-20)


### Bug Fixes

* **appflow:** fix an issue where a network connectivity issue could c… ([#4520](https://github.com/ionic-team/ionic-cli/issues/4520)) ([8634fde](https://github.com/ionic-team/ionic-cli/commit/8634fde68bdfa8f4af724e4a86bb285c44924f37))





# [6.11.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.10.2...@ionic/cli@6.11.0) (2020-07-29)


### Features

* add `capacitor:sync:after` hook ([#4496](https://github.com/ionic-team/ionic-cli/issues/4496)) ([c63d4e1](https://github.com/ionic-team/ionic-cli/commit/c63d4e1957f36549142275c11f7198c68874cef1))





## [6.10.2](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.10.1...@ionic/cli@6.10.2) (2020-07-27)


### Bug Fixes

* use inline uuid v4 function ([#4501](https://github.com/ionic-team/ionic-cli/issues/4501)) ([3743d7b](https://github.com/ionic-team/ionic-cli/commit/3743d7b3e01166dd70716558d55a500419a8bb13))





## [6.10.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.10.0...@ionic/cli@6.10.1) (2020-06-15)


### Bug Fixes

* **cordova:** handle new format of output.json files for Android builds ([#4470](https://github.com/ionic-team/ionic-cli/issues/4470)) ([689b886](https://github.com/ionic-team/ionic-cli/commit/689b886a4a1395aa8bf3c6b0da21bde4a41e0de1))
* use pnpm if configured in build/serve commands ([#4459](https://github.com/ionic-team/ionic-cli/issues/4459)) ([174985f](https://github.com/ionic-team/ionic-cli/commit/174985fca87322d4b52929ae44e93f639665bdf8))





# [6.10.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.9.3...@ionic/cli@6.10.0) (2020-06-02)


### Bug Fixes

* **cordova:** platform is a required input ([1bd3087](https://github.com/ionic-team/ionic-cli/commit/1bd30874f46d89248193c959dd8d769dd99503cf))


### Features

* **login:** default to browser login ([#4451](https://github.com/ionic-team/ionic-cli/issues/4451)) ([0738abd](https://github.com/ionic-team/ionic-cli/commit/0738abd4123b6b5e078cd7ff2f76ed1a26474cf0))





## [6.9.3](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.9.2...@ionic/cli@6.9.3) (2020-05-27)


### Bug Fixes

* **start:** fix issue with starting the react conf app ([daf1f72](https://github.com/ionic-team/ionic-cli/commit/daf1f72372ca3966c57c7e32adc38001cf3a5fdb))





## [6.9.2](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.9.1...@ionic/cli@6.9.2) (2020-05-17)


### Bug Fixes

* **link:** fix GitHub OAuth URL on WSL ([#4442](https://github.com/ionic-team/ionic-cli/issues/4442)) ([93c5bf5](https://github.com/ionic-team/ionic-cli/commit/93c5bf5ba0cc0549a4bf61f534ee30d465bfe35e))
* **package:** fix name of the package deploy name ([#4435](https://github.com/ionic-team/ionic-cli/issues/4435)) ([6f6f9d7](https://github.com/ionic-team/ionic-cli/commit/6f6f9d7540fc064b3ffcbc05b56441f9b5c2efeb))
* **start:** do not prompt for project type when cloning ([#4427](https://github.com/ionic-team/ionic-cli/issues/4427)) ([4ff1622](https://github.com/ionic-team/ionic-cli/commit/4ff162281e327b4740e92513925b6d37b9dfb71e))





## [6.9.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.9.0...@ionic/cli@6.9.1) (2020-05-12)


### Bug Fixes

* pin tslib to avoid "Cannot set property pathExists" error ([689e1f0](https://github.com/ionic-team/ionic-cli/commit/689e1f038b907356ef855a067a76d4822e7072a8))





# [6.9.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.8.0...@ionic/cli@6.9.0) (2020-05-11)


### Bug Fixes

* **capacitor:** do not open browser with `ionic cap run` ([8e3908d](https://github.com/ionic-team/ionic-cli/commit/8e3908d35ba99289e64a268c8a747054afceed92))


### Features

* add `capacitor:run:before` and `capacitor:build:before` hooks ([#4417](https://github.com/ionic-team/ionic-cli/issues/4417)) ([28d8540](https://github.com/ionic-team/ionic-cli/commit/28d854041d418fdd4c36233eb47af177506fdbaf))





# [6.8.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.7.0...@ionic/cli@6.8.0) (2020-05-06)


### Features

* **package:** deployments to destinations (e.g. app stores) ([#4418](https://github.com/ionic-team/ionic-cli/issues/4418)) ([f0314f6](https://github.com/ionic-team/ionic-cli/commit/f0314f64a0a992c6bba9bb46343c1679b8b6521e))





# [6.7.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.6.0...@ionic/cli@6.7.0) (2020-04-29)


### Features

* **capacitor:** add `--no-open` option for run and build ([#4403](https://github.com/ionic-team/ionic-cli/issues/4403)) ([977811e](https://github.com/ionic-team/ionic-cli/commit/977811e652f96aa4f5b4de92a80d9c25ae693d15))





# [6.6.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.5.0...@ionic/cli@6.6.0) (2020-04-14)


### Bug Fixes

* **capacitor:** restore capacitor config after livereload ([cdc0190](https://github.com/ionic-team/ionic-cli/commit/cdc0190eaef38f5a5f1dad79c0953bfd8fa08c57))


### Features

* **capacitor:** warn about server.url during capacitor builds ([5f6b5dd](https://github.com/ionic-team/ionic-cli/commit/5f6b5dd46e0206c7de51a518a1e463a921d85217))
* `ionic capacitor build` command ([#4254](https://github.com/ionic-team/ionic-cli/issues/4254)) ([906fa96](https://github.com/ionic-team/ionic-cli/commit/906fa96ddca7e0156f22d94af3029b29306a6d3a))





# [6.5.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.4.3...@ionic/cli@6.5.0) (2020-04-07)


### Features

* **start:** Default to Capacitor for React ([#4383](https://github.com/ionic-team/ionic-cli/issues/4383)) ([3fd72ec](https://github.com/ionic-team/ionic-cli/commit/3fd72ec828a1a30ddb8439bb9c7123bdcc88e46a))
* **start:** icon/splash from start wizard ([#4376](https://github.com/ionic-team/ionic-cli/issues/4376)) ([bb4c12b](https://github.com/ionic-team/ionic-cli/commit/bb4c12b569685dad228ff7a5588a19ba22c06278))





## [6.4.3](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.4.2...@ionic/cli@6.4.3) (2020-04-05)


### Bug Fixes

* **cordova:** make sure build is complete before reading output.json ([f1abe83](https://github.com/ionic-team/ionic-cli/commit/f1abe8392a6f2eaf910d23558b26228affd467bb))
* **cordova:** use relative path for ipa files ([4831758](https://github.com/ionic-team/ionic-cli/commit/4831758ed12982a1dd4a4cd30f447a304abc4140))





## [6.4.2](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.4.1...@ionic/cli@6.4.2) (2020-04-05)


### Bug Fixes

* **cordova:** use integration root path for file read ([79dc0b1](https://github.com/ionic-team/ionic-cli/commit/79dc0b10a9ff68e0b4a29e826ef95891b0129b8e))





## [6.4.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.4.0...@ionic/cli@6.4.1) (2020-04-02)


### Bug Fixes

* **cordova:** use output.json to deploy correct apk ([#4377](https://github.com/ionic-team/ionic-cli/issues/4377)) ([3f09331](https://github.com/ionic-team/ionic-cli/commit/3f09331daa38f1ebe9eae79831e9d1fe7f28c1a2))





# [6.4.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.3.0...@ionic/cli@6.4.0) (2020-03-30)


### Bug Fixes

* **angular:** convert `--no-<opt>` to `--<opt>=false` for ng ([176ff4b](https://github.com/ionic-team/ionic-cli/commit/176ff4b960c883950f7247120f776ee110816f88))
* **capacitor:** check for capacitor.config.json before integrating ([2d7992c](https://github.com/ionic-team/ionic-cli/commit/2d7992cf2093e671a4d10243bf959a2e0f917b60))


### Features

* **package:** add functionality to deploy to app store ([#4366](https://github.com/ionic-team/ionic-cli/issues/4366)) ([cdd87ac](https://github.com/ionic-team/ionic-cli/commit/cdd87ac795f22d82401f79abb97bef65d8dd1e33))





# [6.3.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.2.2...@ionic/cli@6.3.0) (2020-03-18)


### Features

* **start:** online start experience ([#4356](https://github.com/ionic-team/ionic-cli/issues/4356)) ([fcc5a75](https://github.com/ionic-team/ionic-cli/commit/fcc5a75a11291d069dae123b9d331ecae2d2ac2a))





## [6.2.2](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.2.1...@ionic/cli@6.2.2) (2020-03-16)


### Bug Fixes

* **angular:** always provide the project name fallback ([#4349](https://github.com/ionic-team/ionic-cli/issues/4349)) ([c498f59](https://github.com/ionic-team/ionic-cli/commit/c498f598dac54e8050f041401648efba0597ec3a))
* **multi-app:** use proper paths for integration root ([d53cee3](https://github.com/ionic-team/ionic-cli/commit/d53cee3def8dab8dd3e76c643d73c7c134b327fa))





## [6.2.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.2.0...@ionic/cli@6.2.1) (2020-03-09)


### Bug Fixes

* **react:** accept environment variables into build process ([0932ff0](https://github.com/ionic-team/ionic-cli/commit/0932ff04f45633e51b1d4b78857dbecedaee0c45))





# [6.2.0](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.1.0...@ionic/cli@6.2.0) (2020-03-03)


### Features

* add support for pnpm ([#4330](https://github.com/ionic-team/ionic-cli/issues/4330)) ([47bf076](https://github.com/ionic-team/ionic-cli/commit/47bf076427f3c5d36e241b85cacf30b23f2efd24))
* **init:** add --multi-app option to init monorepos ([42c5199](https://github.com/ionic-team/ionic-cli/commit/42c51996632cdbc6ad6e514f36a584e3a450e380))
* **serve:** -c as alias for --configuration for Angular projects ([c010f37](https://github.com/ionic-team/ionic-cli/commit/c010f375dc8f1d7bc93cb313729f92d4d905a3cc))
* **serve:** add `--public-host` option ([#4331](https://github.com/ionic-team/ionic-cli/issues/4331)) ([8ae752d](https://github.com/ionic-team/ionic-cli/commit/8ae752d60de69063c752870f96a617a270316ca7))
* **start:** add signup prompt ([#4338](https://github.com/ionic-team/ionic-cli/issues/4338)) ([1f23b66](https://github.com/ionic-team/ionic-cli/commit/1f23b662c05114d1645b6f3ab2678e54d517b324))





# 6.1.0 (2020-02-11)


### Features

* **start:** add new list starter option ([#4315](https://github.com/ionic-team/ionic-cli/issues/4315)) ([1df44c1](https://github.com/ionic-team/ionic-cli/commit/1df44c1591f37b89f2b672857740edd6cb2aea67))





## [6.0.2](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.0.1...@ionic/cli@6.0.2) (2020-02-10)

### Bug Fixes

* **capacitor:** allow cleartext for Android live-reload ([#4308](https://github.com/ionic-team/ionic-cli/issues/4308)) ([4d13261](https://github.com/ionic-team/ionic-cli/commit/4d132615fdac01af93404ff939a3364d6f72fb6e))

### Features

* **capacitor:** perform Ionic build for copy and sync ([be42aee](https://github.com/ionic-team/ionic-cli/commit/be42aee601e7abb0fd2f0b3957d561e26b0c688f))
* **config:** make project file configurable ([43ba45c](https://github.com/ionic-team/ionic-cli/commit/43ba45c134abae3279dd8776bd667b7dd9c002a7))

## [6.0.1](https://github.com/ionic-team/ionic-cli/compare/@ionic/cli@6.0.0...@ionic/cli@6.0.1) (2020-02-03)


### Bug Fixes

* **update:** show update message even with command error ([6f32ebc](https://github.com/ionic-team/ionic-cli/commit/6f32ebc7f07f8bdd39ee538c9d605945c4a8e03e))


### Features

* **start**: update "my-first-app" to use Capacitor for Angular and React ([#4307](https://github.com/ionic-team/ionic-cli/issues/4307)) ([de350a7](https://github.com/ionic-team/ionic-cli/commit/de350a757078515a94ebbac3cf45b915970345f7))
* **config:** add `delete` and `del` aliases for `ionic config unset` ([56295c2](https://github.com/ionic-team/ionic-cli/commit/56295c2641cadd350c780db0e559a4bac49a0112))
* **cordova:** add `cdv` alias for `ionic cordova` ([ea503b7](https://github.com/ionic-team/ionic-cli/commit/ea503b7c5580fe449b10a1e11a40179375dfa1e9))
* **cordova:** add `res` alias for `ionic cordova resources` ([2d6ec39](https://github.com/ionic-team/ionic-cli/commit/2d6ec39243752abed92eaa6f3be56460d2b40bf4))
* **integrations:** add `integration` alias for `ionic integrations` ([a9bf5a1](https://github.com/ionic-team/ionic-cli/commit/a9bf5a16c95f0a5760179d5b9db569242d6a12a5))
* **integrations:** add `en` and `add` aliases for `ionic integrations enable` ([b85b5f9](https://github.com/ionic-team/ionic-cli/commit/b85b5f9d4c76e877d126e7185459589d73deb529))
* **integrations:** add `dis`, `delete`, `del`, `remove`, and `rm` aliases for `ionic integrations disable`([fd33cb3](https://github.com/ionic-team/ionic-cli/commit/fd33cb3d0b32520d609850cab83cbba3c767c7e4))
* **integrations:** add `dis`, `delete`, `del`, `remove`, and `rm` aliases for `ionic integrations disable`([fd33cb3](https://github.com/ionic-team/ionic-cli/commit/fd33cb3d0b32520d609850cab83cbba3c767c7e4))


# [6.0.0](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.15...@ionic/cli@6.0.0) (2020-01-25)

The following changes were made in this major release of the Ionic CLI:

* The package name for the Ionic CLI is now `@ionic/cli`! :tada: The old `ionic` package will not be updated to CLI 6.
* The DevApp [has been retired](https://ionicframework.com/docs/appflow/devapp), so `--devapp` has been removed from `ionic serve`. We encourage you to use native tooling (Cordova/Capacitor, Android Studio, and Xcode) to develop apps on hardware and virtual devices.
* The Ionic Resources server is being retired, so `--no-cordova-res` has been removed from `ionic cordova resources`. We encourage you to switch to [`cordova-res`](https://github.com/ionic-team/cordova-res).
* We are now recommending :zap: [Capacitor](https://capacitor.ionicframework.com/) :zap: as the official native runtime for Ionic apps. Cordova will still be supported for this major release.

#### :lollipop: Upgrading from CLI 5

Make sure you have NodeJS v10.3.0+ installed. We recommend [the latest LTS version](https://nodejs.org/).

Uninstall the old Ionic CLI from your computer.

```
npm uninstall -g ionic
```

Install Ionic CLI 6 to your computer.

```
npm install -g @ionic/cli
```

### BREAKING CHANGES

* The npm package for the Ionic CLI is now `@ionic/cli`.
* A minimum of Node.js 10.3.0 is required.
* `--devapp` is no longer an option of `ionic serve`.
* `--no-cordova-res` is no longer an option of `ionic cordova resources`.



## [5.4.15](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.14...ionic@5.4.15) (2020-01-15)


### Bug Fixes

* **react:** indicate serve ready on warn/error as well ([#4280](https://github.com/ionic-team/ionic-cli/issues/4280)) ([1e9b754](https://github.com/ionic-team/ionic-cli/commit/1e9b7546fa561a99c33072908672fcea25c778d9))





## [5.4.14](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.13...ionic@5.4.14) (2020-01-13)


### Bug Fixes

* **deploy:** exclude source maps from manifest ([#4256](https://github.com/ionic-team/ionic-cli/issues/4256)) ([52a33ba](https://github.com/ionic-team/ionic-cli/commit/52a33ba116e28c61287b03e938b5883df45ffb7b))





## [5.4.13](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.12...ionic@5.4.13) (2019-12-13)


### Bug Fixes

* **react:** fix build options, update tonality/style ([8656c60](https://github.com/ionic-team/ionic-cli/commit/8656c60ebb8206d2935669b7654995b82910e048))





## [5.4.12](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.11...ionic@5.4.12) (2019-12-10)

**Note:** Version bump only for package ionic





## [5.4.11](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.10...ionic@5.4.11) (2019-12-09)


### Bug Fixes

* **cordova:** do not detect hardware devices when using emulate ([446a149](https://github.com/ionic-team/ionic-cli/commit/446a1495eefc63995450d8b7e899b44910d70372))





## [5.4.10](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.9...ionic@5.4.10) (2019-12-05)


### Bug Fixes

* **devapp:** enable cordova upon first serve w/ devapp ([fd27ee3](https://github.com/ionic-team/ionic-cli/commit/fd27ee3425ed4c20e8b117e1bb3c8175d709d94b))
* **telemetry:** disable for non-TTY ([81dfff3](https://github.com/ionic-team/ionic-cli/commit/81dfff3d7936519763c11a0f128360434435d179))





## [5.4.9](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.8...ionic@5.4.9) (2019-11-25)


### Bug Fixes

* **link:** don't double encode GitHub URL ([#4230](https://github.com/ionic-team/ionic-cli/issues/4230)) ([cfb593b](https://github.com/ionic-team/ionic-cli/commit/cfb593b177cd98ad41358d1640accd62b78a4c6b))





## [5.4.8](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.7...ionic@5.4.8) (2019-11-24)


### Bug Fixes

* fix parsing of command line options ([060f67c](https://github.com/ionic-team/ionic-cli/commit/060f67cf63d37662ae44c4ae952161464a5d553c))





## [5.4.7](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.6...ionic@5.4.7) (2019-11-21)


### Bug Fixes

* do not try to auth for select commands ([162e733](https://github.com/ionic-team/ionic-cli/commit/162e733eaa5cf2efcaa0e5e087df53c376f62933))





## [5.4.6](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.5...ionic@5.4.6) (2019-11-12)


### Bug Fixes

* **login:** don't doubly encode SSO login URL params ([#4209](https://github.com/ionic-team/ionic-cli/issues/4209)) ([e5fddfb](https://github.com/ionic-team/ionic-cli/commit/e5fddfb175f3eaf53a9dc5dd134d173a56098298))





## [5.4.5](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.4...ionic@5.4.5) (2019-10-30)


### Bug Fixes

* **repair:** ignore missing package-lock.json when repairing ([#4197](https://github.com/ionic-team/ionic-cli/issues/4197)) ([94bddf3](https://github.com/ionic-team/ionic-cli/commit/94bddf38bd895396ab6d0aca87bf5016b45dc42b))





## [5.4.4](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.3...ionic@5.4.4) (2019-10-14)

**Note:** Version bump only for package ionic





## [5.4.3](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.2...ionic@5.4.3) (2019-10-14)

**Note:** Version bump only for package ionic





## [5.4.2](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.1...ionic@5.4.2) (2019-10-01)


### Bug Fixes

* **cordova:** fix hanging issue for run w/ livereload ([#4162](https://github.com/ionic-team/ionic-cli/issues/4162)) ([1001108](https://github.com/ionic-team/ionic-cli/commit/1001108))





## [5.4.1](https://github.com/ionic-team/ionic-cli/compare/ionic@5.4.0...ionic@5.4.1) (2019-09-20)


### Bug Fixes

* **cordova:** fix hanging issue for prepare/compile ([44697cf](https://github.com/ionic-team/ionic-cli/commit/44697cf))





# [5.4.0](https://github.com/ionic-team/ionic-cli/compare/ionic@5.3.0...ionic@5.4.0) (2019-09-20)


### Bug Fixes

* **angular:** fix `--prod` option ([609b80d](https://github.com/ionic-team/ionic-cli/commit/609b80d))


### Features

* **start:** add prompt for framework ([#4161](https://github.com/ionic-team/ionic-cli/issues/4161)) ([8f6ce37](https://github.com/ionic-team/ionic-cli/commit/8f6ce37))





# [5.3.0](https://github.com/ionic-team/ionic-cli/compare/ionic@5.2.8...ionic@5.3.0) (2019-09-18)


### Bug Fixes

* **angular:** show Angular CLI prompts in `ionic generate` ([#4123](https://github.com/ionic-team/ionic-cli/issues/4123)) ([e97f868](https://github.com/ionic-team/ionic-cli/commit/e97f868))
* **cordova:** fix hanging issue with modern iOS build system ([b7758ed](https://github.com/ionic-team/ionic-cli/commit/b7758ed))
* **cordova:** offer confirmation on adding unknown platform ([453f08b](https://github.com/ionic-team/ionic-cli/commit/453f08b))


### Features

* **angular:** document and pass along `--watch` option to ng ([1444212](https://github.com/ionic-team/ionic-cli/commit/1444212))
* **cordova:** --external option for hosting dev server on 0.0.0.0 ([fc6020f](https://github.com/ionic-team/ionic-cli/commit/fc6020f))





## [5.2.8](https://github.com/ionic-team/ionic-cli/compare/ionic@5.2.7...ionic@5.2.8) (2019-09-10)


### Bug Fixes

* **cordova:** use allowlist for supported project types ([167a68c](https://github.com/ionic-team/ionic-cli/commit/167a68c))
* **multi-app:** use proper config path for integrations ([4e8a226](https://github.com/ionic-team/ionic-cli/commit/4e8a226))





## [5.2.7](https://github.com/ionic-team/ionic-cli/compare/ionic@5.2.6...ionic@5.2.7) (2019-08-28)


### Bug Fixes

* **cordova:** use correct package path for release builds ([df34272](https://github.com/ionic-team/ionic-cli/commit/df34272))





## [5.2.6](https://github.com/ionic-team/ionic-cli/compare/ionic@5.2.5...ionic@5.2.6) (2019-08-23)


### Bug Fixes

* **cordova:** handle whitespace in app name when running ([0e662e7](https://github.com/ionic-team/ionic-cli/commit/0e662e7))
* **react:** Disable CRA from opening window so two windows don't open ([#4119](https://github.com/ionic-team/ionic-cli/issues/4119)) ([f10c92c](https://github.com/ionic-team/ionic-cli/commit/f10c92c))





## [5.2.5](https://github.com/ionic-team/ionic-cli/compare/ionic@5.2.4...ionic@5.2.5) (2019-08-14)

**Note:** Version bump only for package ionic





## [5.2.4](https://github.com/ionic-team/ionic-cli/compare/ionic@5.2.3...ionic@5.2.4) (2019-08-07)

**Note:** Version bump only for package ionic





## [5.2.3](https://github.com/ionic-team/ionic-cli/compare/ionic@5.2.2...ionic@5.2.3) (2019-07-15)

**Note:** Version bump only for package ionic





## [5.2.2](https://github.com/ionic-team/ionic-cli/compare/ionic@5.2.1...ionic@5.2.2) (2019-07-09)


### Bug Fixes

* **cordova:** revert to `--no-connect` as default ([e4368a8](https://github.com/ionic-team/ionic-cli/commit/e4368a8))
* **deploy:** support custom Capacitor build directory ([#4065](https://github.com/ionic-team/ionic-cli/issues/4065)) ([6146296](https://github.com/ionic-team/ionic-cli/commit/6146296))





## [5.2.1](https://github.com/ionic-team/ionic-cli/compare/ionic@5.2.0...ionic@5.2.1) (2019-06-28)

* **deploy:** fix bug with `ionic deploy configure` in CI ([7774dfe](https://github.com/ionic-team/ionic-cli/commit/7774dfe))





# [5.2.0](https://github.com/ionic-team/ionic-cli/compare/ionic@5.1.1...ionic@5.2.0) (2019-06-26)


### Bug Fixes

* **capacitor:** save Capacitor CLI in dev deps ([dd2fd86](https://github.com/ionic-team/ionic-cli/commit/dd2fd86))
* **cordova:** rely on package.json for plugins/platforms ([286917f](https://github.com/ionic-team/ionic-cli/commit/286917f))


### Features

* **angular:** pass `--verbose` to Angular CLI ([cf611ed](https://github.com/ionic-team/ionic-cli/commit/cf611ed))
* **angular:** pass `--verbose` to Angular CLI for serve ([3f9e859](https://github.com/ionic-team/ionic-cli/commit/3f9e859))
* **repair:** add `--cordova` flag for only repairing Cordova ([1055b49](https://github.com/ionic-team/ionic-cli/commit/1055b49))





## [5.1.1](https://github.com/ionic-team/ionic-cli/compare/ionic@5.1.0...ionic@5.1.1) (2019-06-26)

**Note:** Version bump only for package ionic





# [5.1.0](https://github.com/ionic-team/ionic-cli/compare/ionic@5.0.3...ionic@5.1.0) (2019-06-21)


### Bug Fixes

* **start:** fix glitch with writing package.json without spaces ([389c398](https://github.com/ionic-team/ionic-cli/commit/389c398))
* subsequent validation for various prompts ([1b92f8a](https://github.com/ionic-team/ionic-cli/commit/1b92f8a))


### Features

* **info:** show available updates for utilities ([a9f4b54](https://github.com/ionic-team/ionic-cli/commit/a9f4b54))
* replace update-notifier ([a232c07](https://github.com/ionic-team/ionic-cli/commit/a232c07))
* **deploy:** command to interactively add deploy plugin ([#4039](https://github.com/ionic-team/ionic-cli/issues/4039)) ([c75e66f](https://github.com/ionic-team/ionic-cli/commit/c75e66f))





## [5.0.3](https://github.com/ionic-team/ionic-cli/compare/ionic@5.0.2...ionic@5.0.3) (2019-06-18)


### Bug Fixes

* **capacitor:** use correct web-dir path for react and capacitor ([#4029](https://github.com/ionic-team/ionic-cli/issues/4029)) ([cdf2579](https://github.com/ionic-team/ionic-cli/commit/cdf2579))
* **cordova:** always generate resources when adding platforms ([3220b2f](https://github.com/ionic-team/ionic-cli/commit/3220b2f))
* **cordova:** don't append --save to platform/plugin management commands ([#4028](https://github.com/ionic-team/ionic-cli/issues/4028)) ([0356d00](https://github.com/ionic-team/ionic-cli/commit/0356d00))
* **cordova:** warn about missing cordova-res when adding platforms ([77fa904](https://github.com/ionic-team/ionic-cli/commit/77fa904))





## [5.0.2](https://github.com/ionic-team/ionic-cli/compare/ionic@5.0.1...ionic@5.0.2) (2019-06-10)


### Bug Fixes

* **capacitor:** use dist for --web-dir for vue/capacitor ([#4012](https://github.com/ionic-team/ionic-cli/issues/4012)) ([0979715](https://github.com/ionic-team/ionic-cli/commit/0979715))
* **cordova:** fix --project flag for cordova commands ([fb9ff0f](https://github.com/ionic-team/ionic-cli/commit/fb9ff0f))
* **cordova:** invoke native-run in integration root ([526eda3](https://github.com/ionic-team/ionic-cli/commit/526eda3))





## [5.0.1](https://github.com/ionic-team/ionic-cli/compare/ionic@5.0.0...ionic@5.0.1) (2019-06-05)


### Bug Fixes

* **cordova:** add port forwarding for --consolelogs ([d2e0c81](https://github.com/ionic-team/ionic-cli/commit/d2e0c81))
* **cordova:** pass --device to native-run if specified ([5db46d5](https://github.com/ionic-team/ionic-cli/commit/5db46d5))





# [5.0.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.12.0...ionic@5.0.0) (2019-05-29)

At a glance, this is what was changed or added in this major release of the Ionic CLI:

* Support for **Ionic React** (beta) :rocket: (`ionic start --type=react`)
* [`native-run`](https://github.com/ionic-team/native-run) is used to deploy app binaries to devices for `ionic cordova run`
* [`cordova-res`](https://github.com/ionic-team/cordova-res) is used to generate Cordova resources locally for `ionic cordova resources`
* `localhost` is now the default host for `ionic serve`, `ionic cordova run -l`, and `ionic capacitor run -l`
    * Port forwarding via `native-run` is used for connected Android devices
    * For iOS hardware devices, you may need to serve your app externally with `--address=0.0.0.0`
* `--devapp` is now a required flag if you want to use DevApp with `ionic serve`
* `--consolelogs` for Angular projects is now available for `ionic cordova run -l`
* Command completion is available for ZSH users (`ionic completion --help`) (see [#2482](https://github.com/ionic-team/ionic-cli/issues/2482) for bash)
* CLI source code targets modern JS, resulting in noticable speed improvements

#### :lollipop: Upgrading from CLI 4

Make sure you have NodeJS v8.9.4+ installed. We recommend [the latest LTS version](https://nodejs.org/).

Install the [`cordova-res`](https://github.com/ionic-team/cordova-res) and [`native-run`](https://github.com/ionic-team/native-run) utilities.

```
npm i -g cordova-res native-run
```

For Angular 8 projects, make sure you have the latest `@ionic/angular-toolkit` installed.

```
npm i @ionic/angular-toolkit@latest
```

For Angular 7 projects, make sure you have the [latest 1.x](https://www.npmjs.com/package/@ionic/angular-toolkit?activeTab=versions) `@ionic/angular-toolkit` installed.

```
npm i @ionic/angular-toolkit@1
```


### Bug Fixes

* **capacitor:** send --npm-client param to capacitor init ([#3963](https://github.com/ionic-team/ionic-cli/issues/3963)) ([44b0918](https://github.com/ionic-team/ionic-cli/commit/44b0918))
* **cordova:** prefer plugged-in devices, be explicit with Cordova ([ef8296b](https://github.com/ionic-team/ionic-cli/commit/ef8296b))
* **doctor:** relax the viewport regex ([d0bc021](https://github.com/ionic-team/ionic-cli/commit/d0bc021))
* **open:** fix unbound listener ([e63b74a](https://github.com/ionic-team/ionic-cli/commit/e63b74a))
* **prepare:** check config and platforms dir for platform state ([d9e1ced](https://github.com/ionic-team/ionic-cli/commit/d9e1ced))
* **react:** support react git repo ([#3982](https://github.com/ionic-team/ionic-cli/issues/3982)) ([c06857f](https://github.com/ionic-team/ionic-cli/commit/c06857f))


### chore

* **serve:** `--devapp` required for DevApp ([5ad11ef](https://github.com/ionic-team/ionic-cli/commit/5ad11ef))
* **serve:** remove `--local` option ([806eaaa](https://github.com/ionic-team/ionic-cli/commit/806eaaa))
* **serve:** switch default host to `localhost` ([d2a32de](https://github.com/ionic-team/ionic-cli/commit/d2a32de))
* require Node 8 ([5670e68](https://github.com/ionic-team/ionic-cli/commit/5670e68))


### Features

* **cordova:** handle lack of port forwarding in ios ([d68faf1](https://github.com/ionic-team/ionic-cli/commit/d68faf1))
* add -v as shortcut for --version ([d917e8e](https://github.com/ionic-team/ionic-cli/commit/d917e8e))
* **start:** add conference and my-first-app starter templates for angular ([#3978](https://github.com/ionic-team/ionic-cli/issues/3978)) ([ea26181](https://github.com/ionic-team/ionic-cli/commit/ea26181))
* Add React project type ([#3936](https://github.com/ionic-team/ionic-cli/issues/3936)) ([ef852fa](https://github.com/ionic-team/ionic-cli/commit/ef852fa))
* **angular:** Ionic 4 commands no longer beta ([16be793](https://github.com/ionic-team/ionic-cli/commit/16be793))
* **cordova:** check for `native-run` before running ([89ffd21](https://github.com/ionic-team/ionic-cli/commit/89ffd21))
* **cordova:** instructions on how to fix faulty Android SDKs ([ce87944](https://github.com/ionic-team/ionic-cli/commit/ce87944))
* **cordova:** use `cordova-res` by default ([83e48cf](https://github.com/ionic-team/ionic-cli/commit/83e48cf))
* **cordova:** use `native-run` by default ([eadcba0](https://github.com/ionic-team/ionic-cli/commit/eadcba0))
* **help:** color refactor ([5938429](https://github.com/ionic-team/ionic-cli/commit/5938429))
* **info:** native-run and cordova-res versions ([d6af864](https://github.com/ionic-team/ionic-cli/commit/d6af864))
* **login:** authenticate using stdin ([d88529f](https://github.com/ionic-team/ionic-cli/commit/d88529f))
* **serve:** support `--consolelogs` for cordova serve in angular projects ([#3900](https://github.com/ionic-team/ionic-cli/issues/3900)) ([17f1438](https://github.com/ionic-team/ionic-cli/commit/17f1438))
* Command-Line Completions ([9f66512](https://github.com/ionic-team/ionic-cli/commit/9f66512))


### BREAKING CHANGES

* **cordova:** `ionic cordova resources` no longer generates resources
using Ionic servers by default. Instead, `cordova-res` is used to
generate resources locally. PSD and AI file formats are no longer
supported in this new flow. The old behavior is available by specifying
`--no-cordova-res`.
* **cordova:** `ionic cordova run/emulate` no longer use Cordova to
deploy apps by default. `cordova run`, which builds and deploys the app,
is no longer used. Instead, `cordova build` is used to build the app and
then it is deployed to devices using `native-run`. The old behavior is
available by specifying `--no-native-run`. When using Cordova to run,
unless you manually forward ports, you will need to also specify
`--address=0.0.0.0` (or any host accessible externally).
* **serve:** For DevApp usage, the `--devapp` flag is now required
for all project types, instead of being automatic. This change was made
in conjunction with changing the default host from `0.0.0.0` to
`localhost`. By explicitly specifying `--devapp`, however, `0.0.0.0` is
used if `--address` is not specified.
* **serve:** `ionic serve` and other commands using the dev server
will no longer be hosted on the BIND ALL address (0.0.0.0) by default.
`localhost` is the new default. The old behavior is available by passing
`--address=0.0.0.0`.
* **serve:** The `ionic serve --local` option is now irrelevant. The default address is
changing to `localhost`.
* A minimum of Node.js 8.9.4 is required.
* **help:** option/command/namespace groups are now `MetadataGroup`





<a name="4.12.0"></a>
# [4.12.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.11.0...ionic@4.12.0) (2019-03-12)


### Features

* **enterprise:** add shortcut for registering ([a1890b4](https://github.com/ionic-team/ionic-cli/commit/a1890b4))
* add `i` as alias for `integrations` ([14a7ddb](https://github.com/ionic-team/ionic-cli/commit/14a7ddb))
* **integrations:** add `--web-dir` option for capacitor integration ([#3895](https://github.com/ionic-team/ionic-cli/issues/3895)) ([8a1c4b2](https://github.com/ionic-team/ionic-cli/commit/8a1c4b2))
* **integrations:** ionic enterprise integration ([#3905](https://github.com/ionic-team/ionic-cli/issues/3905)) ([b071fcb](https://github.com/ionic-team/ionic-cli/commit/b071fcb))




<a name="4.11.0"></a>
# [4.11.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.10.4...ionic@4.11.0) (2019-03-06)


### Features

* **cordova:** add experimental `--cordova-res` flag ([16cdef8](https://github.com/ionic-team/ionic-cli/commit/16cdef8))
* **cordova:** add experimental `--native-run` flag ([a80d465](https://github.com/ionic-team/ionic-cli/commit/a80d465))




<a name="4.10.4"></a>
## [4.10.4](https://github.com/ionic-team/ionic-cli/compare/ionic@4.10.3...ionic@4.10.4) (2019-02-27)




**Note:** Version bump only for package ionic

<a name="4.10.3"></a>
## [4.10.3](https://github.com/ionic-team/ionic-cli/compare/ionic@4.10.2...ionic@4.10.3) (2019-02-15)




**Note:** Version bump only for package ionic

<a name="4.10.2"></a>
## [4.10.2](https://github.com/ionic-team/ionic-cli/compare/ionic@4.10.1...ionic@4.10.2) (2019-02-04)


### Bug Fixes

* **angular:** pass `--project` and `--configuration` for custom scripts ([2cf724f](https://github.com/ionic-team/ionic-cli/commit/2cf724f))




<a name="4.10.1"></a>
## [4.10.1](https://github.com/ionic-team/ionic-cli/compare/ionic@4.10.0...ionic@4.10.1) (2019-01-30)


### Bug Fixes

* **cordova:** only forward correct options ([817879b](https://github.com/ionic-team/ionic-cli/commit/817879b))




<a name="4.10.0"></a>
# [4.10.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.9.0...ionic@4.10.0) (2019-01-29)


### Bug Fixes

* **ionic-angular:** link to proper v3 docs ([a89c097](https://github.com/ionic-team/ionic-cli/commit/a89c097))


### Features

* **serve:** add DevApp support for Ionic 4 projects ([#3830](https://github.com/ionic-team/ionic-cli/issues/3830)) ([6edf373](https://github.com/ionic-team/ionic-cli/commit/6edf373))




<a name="4.9.0"></a>
# [4.9.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.8.0...ionic@4.9.0) (2019-01-23)


### Features

* **custom:** run ionic:build/ionic:serve scripts ([9898fa8](https://github.com/ionic-team/ionic-cli/commit/9898fa8))
* **resources:** --cordova-res option for local resource generation ([3c27e05](https://github.com/ionic-team/ionic-cli/commit/3c27e05))
* **start:** make Ionic 4 the default for new projects ([#3820](https://github.com/ionic-team/ionic-cli/issues/3820)) ([0195f96](https://github.com/ionic-team/ionic-cli/commit/0195f96))




<a name="4.8.0"></a>
# [4.8.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.7.1...ionic@4.8.0) (2019-01-14)


### Features

* **appflow:** command to create deploy builds ([#3815](https://github.com/ionic-team/ionic-cli/issues/3815)) ([d346e03](https://github.com/ionic-team/ionic-cli/commit/d346e03))




<a name="4.7.1"></a>
## [4.7.1](https://github.com/ionic-team/ionic-cli/compare/ionic@4.7.0...ionic@4.7.1) (2019-01-08)




**Note:** Version bump only for package ionic

<a name="4.7.0"></a>
# [4.7.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.6.0...ionic@4.7.0) (2019-01-07)


### Bug Fixes

* **doctor:** handle multilines for viewport-fit-not-set ([#3809](https://github.com/ionic-team/ionic-cli/issues/3809)) ([6aa7ae6](https://github.com/ionic-team/ionic-cli/commit/6aa7ae6))
* **executor:** Exclude options for command argument parsing ([#3798](https://github.com/ionic-team/ionic-cli/issues/3798)) ([514015f](https://github.com/ionic-team/ionic-cli/commit/514015f))
* **serve:** handle error in opn with debug statement ([89b6d33](https://github.com/ionic-team/ionic-cli/commit/89b6d33))


### Features

* **appflow:** command to create package builds ([#3808](https://github.com/ionic-team/ionic-cli/issues/3808)) ([149f06e](https://github.com/ionic-team/ionic-cli/commit/149f06e))
* **cordova:** auto-forward port when using --native-run ([0da50ac](https://github.com/ionic-team/ionic-cli/commit/0da50ac))




<a name="4.6.0"></a>
# [4.6.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.5.0...ionic@4.6.0) (2018-12-19)


### Bug Fixes

* **cordova:** warn for prepare w/o platforms ([385bdf2](https://github.com/ionic-team/ionic-cli/commit/385bdf2))


### Features

* **serve:** collapse numbered chunk output and summarize ([5ac6834](https://github.com/ionic-team/ionic-cli/commit/5ac6834))
* **start:** update for Ionic Framework 4.0 RC ([7e943cc](https://github.com/ionic-team/ionic-cli/commit/7e943cc))




<a name="4.5.0"></a>
# [4.5.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.4.0...ionic@4.5.0) (2018-11-27)


### Bug Fixes

* **cordova:** do not error for ctrl+c during livereload ([facc96b](https://github.com/ionic-team/ionic-cli/commit/facc96b))
* **serve:** ignore link-local addresses ([#3761](https://github.com/ionic-team/ionic-cli/issues/3761)) ([1b7fd90](https://github.com/ionic-team/ionic-cli/commit/1b7fd90))
* **telemetry:** disable automatically for CI ([217ca12](https://github.com/ionic-team/ionic-cli/commit/217ca12))


### Features

* Ionic Appflow rebranding ([16360af](https://github.com/ionic-team/ionic-cli/commit/16360af))
* **cordova:** add `--native-run` option to Cordova run ([#3757](https://github.com/ionic-team/ionic-cli/issues/3757)) ([9ef53ad](https://github.com/ionic-team/ionic-cli/commit/9ef53ad))




<a name="4.4.0"></a>
# [4.4.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.3.1...ionic@4.4.0) (2018-11-20)


### Bug Fixes

* **multi-app:** properly handle bare projects ([3f84a6f](https://github.com/ionic-team/ionic-cli/commit/3f84a6f)), closes [/github.com/ionic-team/ionic-docs/issues/83#issuecomment-439655706](https://github.com//github.com/ionic-team/ionic-docs/issues/83/issues/issuecomment-439655706)
* **project:** write determined project type to config ([307d81f](https://github.com/ionic-team/ionic-cli/commit/307d81f))


### Features

* **build:** show build progress ([3090615](https://github.com/ionic-team/ionic-cli/commit/3090615))
* **help:** show value hint for options ([aa13ba8](https://github.com/ionic-team/ionic-cli/commit/aa13ba8))
* **init:** add `ionic init` command ([4a12b17](https://github.com/ionic-team/ionic-cli/commit/4a12b17))
* **login:** SSO authentication flow ([#3741](https://github.com/ionic-team/ionic-cli/issues/3741)) ([71b319a](https://github.com/ionic-team/ionic-cli/commit/71b319a))
* **serve:** forward `--ssl` to Angular CLI ([815b49a](https://github.com/ionic-team/ionic-cli/commit/815b49a))




<a name="4.3.1"></a>
## [4.3.1](https://github.com/ionic-team/ionic-cli/compare/ionic@4.3.0...ionic@4.3.1) (2018-11-04)


### Bug Fixes

* **bin:** stringify unresolved promise event ([788a5ec](https://github.com/ionic-team/ionic-cli/commit/788a5ec))
* **bootstrap:** supply env for CLI <4.3.0 ([78dbda8](https://github.com/ionic-team/ionic-cli/commit/78dbda8))
* **multi-app:** hide project warnings during start ([b1ecd77](https://github.com/ionic-team/ionic-cli/commit/b1ecd77))
* **start:** fix stdio freezing issue on Windows ([#3725](https://github.com/ionic-team/ionic-cli/issues/3725)) ([a570770](https://github.com/ionic-team/ionic-cli/commit/a570770))




<a name="4.3.0"></a>
# [4.3.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.2.1...ionic@4.3.0) (2018-10-31)


### Bug Fixes

* **capacitor:** switch off livereload for --no-build ([9960047](https://github.com/ionic-team/ionic-cli/commit/9960047))
* **help:** filter out unnecessary global options ([7809c99](https://github.com/ionic-team/ionic-cli/commit/7809c99))
* **ssh:** adjust validator to work for OpenSSH 7.8 ([dcc598a](https://github.com/ionic-team/ionic-cli/commit/dcc598a))
* **terminal:** adjust some feature detection on windows ([8a2ed99](https://github.com/ionic-team/ionic-cli/commit/8a2ed99))


### Features

* **capacitor:** add --livereload-url option for custom dev server ([b7738f5](https://github.com/ionic-team/ionic-cli/commit/b7738f5))
* **cordova:** add --livereload-url option for custom dev server ([ad57e36](https://github.com/ionic-team/ionic-cli/commit/ad57e36))
* **integrations:** --root option for choosing an alternative location ([7e8f11e](https://github.com/ionic-team/ionic-cli/commit/7e8f11e))
* **multi-app:** determine active project via cwd path match ([f83dc5b](https://github.com/ionic-team/ionic-cli/commit/f83dc5b))
* **resources:** generate resources without needing platform installation ([4f20554](https://github.com/ionic-team/ionic-cli/commit/4f20554))
* **start:** better multi-app support ([3c70e87](https://github.com/ionic-team/ionic-cli/commit/3c70e87))




<a name="4.2.1"></a>
## [4.2.1](https://github.com/ionic-team/ionic-cli/compare/ionic@4.2.0...ionic@4.2.1) (2018-10-05)


### Bug Fixes

* **doctor:** fix viewport-fit-not-set for ionic1 ([826b9ae](https://github.com/ionic-team/ionic-cli/commit/826b9ae))
* **info:** show versions for [@ionic](https://github.com/ionic)/angular-toolkit ([9d1824a](https://github.com/ionic-team/ionic-cli/commit/9d1824a))




<a name="4.2.0"></a>
# [4.2.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.1.2...ionic@4.2.0) (2018-10-03)


### Bug Fixes

* **cordova:** ng should ignore separated args for Cordova build ([16a0111](https://github.com/ionic-team/ionic-cli/commit/16a0111))
* **lab:** use correct query params for project type ([4801680](https://github.com/ionic-team/ionic-cli/commit/4801680))
* **serve:** fix incorrect message about app-scripts not being installed ([abd665b](https://github.com/ionic-team/ionic-cli/commit/abd665b))
* **serve:** unnecessary message about utility CLI exiting during Ctrl+C ([8e78bf3](https://github.com/ionic-team/ionic-cli/commit/8e78bf3))


### Features

* new `ionic repair` command ([7588233](https://github.com/ionic-team/ionic-cli/commit/7588233))




<a name="4.1.2"></a>
## [4.1.2](https://github.com/ionic-team/ionic-cli/compare/ionic@4.1.1...ionic@4.1.2) (2018-09-05)


### Bug Fixes

* **capacitor:** use integration root for Capacitor CLI ([81a45d5](https://github.com/ionic-team/ionic-cli/commit/81a45d5))




<a name="4.1.1"></a>
## [4.1.1](https://github.com/ionic-team/ionic-cli/compare/ionic@4.1.0...ionic@4.1.1) (2018-08-20)


### Bug Fixes

* **cordova:** respect --nosave for platform/plugin add ([eb4934b](https://github.com/ionic-team/ionic-cli/commit/eb4934b))
* **deploy:** exclude any existing pro-manifest.json files ([#3527](https://github.com/ionic-team/ionic-cli/issues/3527)) ([d03057d](https://github.com/ionic-team/ionic-cli/commit/d03057d))
* **shell:** allow output() to fail with original error ([e6a5bff](https://github.com/ionic-team/ionic-cli/commit/e6a5bff))
* **shell:** check if process is still alive before sending signal ([0ff1e48](https://github.com/ionic-team/ionic-cli/commit/0ff1e48))




<a name="4.1.0"></a>
# [4.1.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.0.6...ionic@4.1.0) (2018-08-15)


### Bug Fixes

* **capacitor:** pass in project/package id during start ([1357c5c](https://github.com/ionic-team/ionic-cli/commit/1357c5c))
* **cordova:** properly error for multiple IPs with non-interactive mode ([0346adc](https://github.com/ionic-team/ionic-cli/commit/0346adc))
* **cordova:** remove unwanted allow-navigation entries ([77984e1](https://github.com/ionic-team/ionic-cli/commit/77984e1))
* **info:** disable update check for cordova cli ([8310ff6](https://github.com/ionic-team/ionic-cli/commit/8310ff6))
* **info:** remove version.json warning for v1 ([78c3582](https://github.com/ionic-team/ionic-cli/commit/78c3582))
* **link:** support new repo association types ([1c1e1f1](https://github.com/ionic-team/ionic-cli/commit/1c1e1f1))


### Features

* **capacitor:** add run command ([62a2918](https://github.com/ionic-team/ionic-cli/commit/62a2918))
* **capacitor:** document platform argument, prompt when required ([2a312ab](https://github.com/ionic-team/ionic-cli/commit/2a312ab))
* **capacitor:** install platform if missing ([9e29235](https://github.com/ionic-team/ionic-cli/commit/9e29235))
* **capacitor:** prompt for supported platforms when adding ([54c7d55](https://github.com/ionic-team/ionic-cli/commit/54c7d55))
* **capacitor:** unlock capacitor commands as beta ([2480a01](https://github.com/ionic-team/ionic-cli/commit/2480a01))
* **info:** print whitelisted cordova plugins ([c266b7b](https://github.com/ionic-team/ionic-cli/commit/c266b7b))




<a name="4.0.6"></a>
## [4.0.6](https://github.com/ionic-team/ionic-cli/compare/ionic@4.0.5...ionic@4.0.6) (2018-08-09)


### Bug Fixes

* **serve:** fix unclosed connection issue again ([#3500](https://github.com/ionic-team/ionic-cli/issues/3500)) ([1f0ef3b](https://github.com/ionic-team/ionic-cli/commit/1f0ef3b))




<a name="4.0.5"></a>
## [4.0.5](https://github.com/ionic-team/ionic-cli/compare/ionic@4.0.4...ionic@4.0.5) (2018-08-07)




**Note:** Version bump only for package ionic

<a name="4.0.4"></a>
## [4.0.4](https://github.com/ionic-team/ionic-cli/compare/ionic@4.0.3...ionic@4.0.4) (2018-08-06)


### Bug Fixes

* **serve:** properly cleanup child processes ([#3481](https://github.com/ionic-team/ionic-cli/issues/3481)) ([38217bf](https://github.com/ionic-team/ionic-cli/commit/38217bf))




<a name="4.0.3"></a>
## [4.0.3](https://github.com/ionic-team/ionic-cli/compare/ionic@4.0.2...ionic@4.0.3) (2018-08-02)


### Bug Fixes

* **build:** prompt to install "build cli" for all projects ([2862762](https://github.com/ionic-team/ionic-cli/commit/2862762))
* **serve:** await connectivity on specified host, not localhost ([#3444](https://github.com/ionic-team/ionic-cli/issues/3444)) ([bf10674](https://github.com/ionic-team/ionic-cli/commit/bf10674))
* **serve:** check all network interfaces for an available port ([30fd6ef](https://github.com/ionic-team/ionic-cli/commit/30fd6ef))
* **serve:** fix --livereload for device/emulator ([f31e79d](https://github.com/ionic-team/ionic-cli/commit/f31e79d))
* **serve:** use correct livereload port option for v1 ([bf3e775](https://github.com/ionic-team/ionic-cli/commit/bf3e775))




<a name="4.0.2"></a>
## [4.0.2](https://github.com/ionic-team/ionic-cli/compare/ionic@4.0.1...ionic@4.0.2) (2018-07-30)


### Bug Fixes

* **cordova:** default to `cordova prepare` without platforms ([d40d961](https://github.com/ionic-team/ionic-cli/commit/d40d961))
* **resources:** fix hanging issue ([#3429](https://github.com/ionic-team/ionic-cli/issues/3429)) ([6b7c732](https://github.com/ionic-team/ionic-cli/commit/6b7c732))
* **build:** properly pass --target to remove fonts for cordova ([530d87a](https://github.com/ionic-team/ionic-cli/commit/530d87a))
* **generate:** run in current directory ([54c632b](https://github.com/ionic-team/ionic-cli/commit/54c632b))
* **info:** filter out hidden files/folders ([2e56dd7](https://github.com/ionic-team/ionic-cli/commit/2e56dd7))
* **info:** show 'not available' when cordova is missing ([db60879](https://github.com/ionic-team/ionic-cli/commit/db60879))




<a name="4.0.1"></a>
## [4.0.1](https://github.com/ionic-team/ionic-cli/compare/ionic@4.0.0...ionic@4.0.1) (2018-07-26)


### Bug Fixes

* **generate:** remove pages/ prefix recommendation ([#3392](https://github.com/ionic-team/ionic-cli/issues/3392)) ([23d0db6](https://github.com/ionic-team/ionic-cli/commit/23d0db6))
* **help:** properly show option decorations ([b2509de](https://github.com/ionic-team/ionic-cli/commit/b2509de))




<a name="4.0.0"></a>
# [4.0.0](https://github.com/ionic-team/ionic-cli/compare/ionic@4.0.0-rc.13...ionic@4.0.0) (2018-07-25)




**Note:** Version bump only for package ionic

This release offers support for :sparkles: **Ionic 4** :sparkles: (beta).

:memo: Use the new [CLI Documentation](https://beta.ionicframework.com/docs/cli) on the beta framework documentation website for CLI 4.

#### :lollipop: Upgrading from CLI 3

Aside from a few edge cases listed below, upgrading to CLI 4 should be seamless.

**Ionic 2/3**: The CLI will continue working with apps using `@ionic/app-scripts` for tooling (please [update to the latest version](https://github.com/ionic-team/ionic-app-scripts) to avoid any issues). The CLI will continue to support projects that have yet to migrate to Ionic 4 w/ Angular CLI for tooling. For those who wish to migrate v3 apps to v4, see the [Migration Guide](https://beta.ionicframework.com/docs/building/migration).

**Ionic 1**: For Ionic 1 projects, a new toolkit has been introduced to slim down the main CLI package. All functionality is still supported, but the `@ionic/v1-toolkit` package needs to be installed.

#### :boom: Breaking Changes

* Support for legacy Ionic Cloud ended on January 31st, 2018. The `ionic upload` and `ionic package` commands have been removed from the CLI. Support for [Ionic Appflow](https://ionicframework.com/appflow/) will be a major focus for the CLI going forward. :ok_hand:
* The `app_id` property in `ionic.config.json` has been renamed to `pro_id` and is now optional (see [#3038](https://github.com/ionic-team/ionic-cli/issues/3038)). The CLI automatically detects this and changes it, but this notice is here if your build scripts rely on the setting.
* `ionic build` will no longer run `cordova prepare`. Instead, run `ionic cordova prepare <platform>`, which performs an Ionic build beforehand.
* `ionic cordova prepare` will no longer run an Ionic build without a platform, e.g. `ionic cordova prepare ios` (see [#3653](https://github.com/ionic-team/ionic-cli/issues/3653))
* Ionic Lab has been moved into the [`@ionic/lab`](https://github.com/ionic-team/ionic-cli/tree/develop/packages/@ionic/lab) package, which will need to be installed for Lab to work.
* The `conference` starter template has been removed from `ionic start`. To clone existing apps (as opposed to starting new apps from starter templates), please use the app's repository URL. For example, to create the conference app, use `ionic start "Conference App" https://github.com/ionic-team/ionic-conference-app`.
* The `--display-name` option for `ionic start` has been removed. The `name` argument is now used as the display name and slugified for directory name, package name, etc. To provide a custom slug, use `--project-id` (see [#3038](https://github.com/ionic-team/ionic-cli/issues/3038)).
* The `ionic:watch:before` npm script hook has been renamed to `ionic:serve:before`, but behaves the same.
* `ionic doctor check` will now _only_ print issues and exit with exit code 1 if issues are found. Use `ionic doctor treat` to attempt automatic fixes.
* `ionic doctor ignore` has been removed in favor of `ionic config set -g doctor.issues.<issue>.ignored true`).
* Ionic 1 build/serve functionality has been moved into the [`@ionic/v1-toolkit`](https://github.com/ionic-team/ionic-cli/tree/develop/packages/@ionic/v1-toolkit) package, which will need to be installed in your Ionic 1 project(s). The file watcher, [chokidar](https://github.com/paulmillr/chokidar), has been updated to 2.0.0, which will require those using `watchPatterns` to [always use POSIX-style slashes](https://github.com/paulmillr/chokidar/blob/master/CHANGELOG.md#chokidar-200-dec-29-2017) (not an issue if you've never used a backslash in globs for Windows).
* The gulp integration has been removed from the CLI and put into the [`@ionic/v1-toolkit`](https://github.com/ionic-team/ionic-cli/tree/develop/packages/@ionic/v1-toolkit) package, which is only for Ionic v1 apps.

#### :rocket: Enhancements

* `ionic s` is now an alias for `ionic serve`.
* No need for `@ionic/cli-plugin-proxy`. Proxy support is now built-in. Use existing environment variables or use `ionic config set -g proxy <url>`.
* New `ionic config unset` command for deleting config values.
* New `ionic doctor treat` command that attempts automatic fixes of detected issues.
* If `ionic:build` or `ionic:serve` npm scripts are defined in your `package.json`, the Ionic CLI will use them for the Ionic build/serve instead of the default for your project type.
* Automatic login via `IONIC_TOKEN` environment variable [#2410](https://github.com/ionic-team/ionic-cli/issues/2410)
* `--no-color` flag for turning off CLI colors
* `--no-build` option for `ionic cordova run` and `ionic cordova emulate` [#2930](https://github.com/ionic-team/ionic-cli/pull/2930)
* Better monorepo support. See the discussion in [#2232](https://github.com/ionic-team/ionic-cli/issues/2232).
* Multi-app support for new Angular projects [#3281](https://github.com/ionic-team/ionic-cli/issues/3281)
* Added experimental `ionic ssl generate` command for generating `localhost` SSL certificates for use with `ionic serve`. :memo: HTTPS support in `ionic serve` isn't quite finished yet (see [#3305](https://github.com/ionic-team/ionic-cli/issues/3305)).

#### :bug: Bug Fixes

* Interactivity is now disabled when not in a TTY. See [#3047](https://github.com/ionic-team/ionic-cli/issues/3047).
* Respect `--nosave` flag for `ionic cordova platform` and `ionic cordova plugin` [#2946](https://github.com/ionic-team/ionic-cli/issues/2946)
* Chain `--verbose` flag to Cordova for `ionic cordova` commands [#2919](https://github.com/ionic-team/ionic-cli/issues/2919)
* Fixed newlines in piped output from underlying CLIs.

#### :house: Internal

* A huge amount of code refactoring has been accomplished to prepare the CLI for a scalable, flexible future. Changes in behavior and help output based upon environment and config are now trivially accomplished.
* The [CLI Framework](https://github.com/ionic-team/ionic-cli/tree/develop/packages/%40ionic/cli-framework), a (currently) internal framework for building general-purpose command-line programs, has had many features added to support the utility CLIs such as `ionic-lab` and `ionic-v1`.
* Ionic Lab has been rebuilt using [StencilJS](https://stenciljs.com) and now works for any Ionic Framework version.

## Older Changes

* [3.x `CHANGELOG.md`](https://github.com/ionic-team/ionic-cli/blob/3.x/CHANGELOG.md)
* [1.x-2.x `CHANGELOG.md`](https://github.com/ionic-team/ionic-cli/blob/2.x/CHANGELOG.md)
