import ElementNamedNodeMap from '../element/ElementNamedNodeMap.js';
/**
 * Named Node Map.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/NamedNodeMap
 */
export default class HTMLElementNamedNodeMap extends ElementNamedNodeMap {
    /**
     * @override
     */
    setNamedItem(item) {
        const replacedItem = super.setNamedItem(item);
        if (item.name === 'style' && this._ownerElement._style) {
            this._ownerElement._style.cssText = item.value;
        }
        return replacedItem || null;
    }
    /**
     * @override
     */
    _removeNamedItem(name) {
        const removedItem = super._removeNamedItem(name);
        if (removedItem && removedItem.name === 'style' && this._ownerElement._style) {
            this._ownerElement._style.cssText = '';
        }
        return removedItem;
    }
}
//# sourceMappingURL=HTMLElementNamedNodeMap.js.map