import type { Binding, NodePath } from '@babel/traverse';
import type { Identifier, JSXIdentifier, Node } from '@babel/types';
export declare function reference(path: NodePath<Identifier | JSXIdentifier>, referencePath?: NodePath, force?: boolean): void;
export declare function dereference(path: NodePath<Identifier | JSXIdentifier>): Binding | null;
export declare function referenceAll(path: NodePath): void;
type ReplaceAction = [action: 'replace', what: NodePath, by: Node];
type RemoveAction = [action: 'remove', what: NodePath];
export declare function findActionForNode(path: NodePath): RemoveAction | ReplaceAction | null;
declare function applyAction(action: ReplaceAction | RemoveAction): void;
declare function removeWithRelated(paths: NodePath[]): void;
declare function mutate<T extends NodePath>(path: T, fn: (p: T) => NodePath[] | void): void;
export { applyAction, mutate, removeWithRelated };
