import type { NodePath } from '@babel/traverse';
import type { Program } from '@babel/types';
import { BaseProcessor } from '@wyw-in-js/processor-utils';
import type { IFileContext, TagSource } from '@wyw-in-js/processor-utils';
import type { StrictOptions } from '@wyw-in-js/shared';
import type { IImport } from './collectExportsAndImports';
type DefinedProcessor = [ProcessorClass, TagSource];
type DefinedProcessors = Map<string, DefinedProcessor>;
export type ProcessorClass = new (...args: ConstructorParameters<typeof BaseProcessor>) => BaseProcessor;
export declare function getProcessorForImport({ imported, source }: IImport, filename: string | null | undefined, options: Pick<StrictOptions, 'tagResolver'>): [ProcessorClass | null, TagSource];
export declare function getDefinedProcessors(imports: IImport[], path: NodePath<Program>, filename: string | null | undefined, options: Pick<StrictOptions, 'tagResolver'>): DefinedProcessors;
export declare function applyProcessors(path: NodePath<Program>, fileContext: IFileContext, options: Pick<StrictOptions, 'classNameSlug' | 'displayName' | 'evaluate' | 'tagResolver'>, callback: (processor: BaseProcessor) => void): void;
export {};
