"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPS = void 0;
const path_1 = require("path");
const project_1 = require("@trapezedev/project");
async function execute(ctx, op) {
    const xmlOp = op;
    const entries = xmlOp.value;
    if (!ctx.project.android) {
        return;
    }
    for (const entry of entries) {
        let filename = entry.file;
        let jsonFile = null;
        if (entry.resFile) {
            filename = (0, path_1.join)(ctx.project.android.getResourcesPath(), entry.resFile);
        }
        jsonFile = ctx.project.android.getProjectFile(filename, (filename) => new project_1.JsonFile(filename, ctx.project.vfs));
        if (!jsonFile) {
            return;
        }
        await jsonFile.load();
        if (entry.set) {
            jsonFile.set(entry.set);
        }
        if (entry.merge) {
            jsonFile.merge(entry.merge);
        }
    }
}
exports.default = execute;
exports.OPS = [
    'android.json'
];
//# sourceMappingURL=json.js.map