"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPS = void 0;
const log_1 = require("../../util/log");
async function execute(ctx, op) {
    var _a;
    const entries = op.value;
    const gradleFiles = new Map();
    for (let entry of entries) {
        if (!gradleFiles.has(entry.file)) {
            const file = await ((_a = ctx.project.android) === null || _a === void 0 ? void 0 : _a.getGradleFile(entry.file));
            gradleFiles.set(entry.file, file);
        }
        const gradleFile = gradleFiles.get(entry.file);
        if (!gradleFile) {
            log_1.logger.warn(`Skipping ${op.id} - can't locate Gradle file ${entry.file}`);
            continue;
        }
        if (entry.replace) {
            await gradleFile.replaceProperties(entry.target, entry.replace, entry.exact);
        }
        else if (typeof entry.insert === 'string') {
            await gradleFile.insertFragment(entry.target, entry.insert, entry.exact);
        }
        else if (Array.isArray(entry.insert)) {
            await gradleFile.insertProperties(entry.target, entry.insert, entry.insertType, entry.exact);
        }
        else {
            throw new Error(`Invalid \'insert\' type for gradle operation. Must be a string or array of objects: ${JSON.stringify(entry.insert, null, 2)}`);
        }
    }
}
exports.default = execute;
exports.OPS = [
    'android.gradle'
];
//# sourceMappingURL=gradle.js.map