import { createSelectorCreator, weakMapMemoize } from 'reselect';
export declare const createDraftSafeSelectorCreator: typeof createSelectorCreator;
/**
 * "Draft-Safe" version of `reselect`'s `createSelector`:
 * If an `immer`-drafted object is passed into the resulting selector's first argument,
 * the selector will act on the current draft value, instead of returning a cached value
 * that might be possibly outdated if the draft has been modified since.
 * @public
 */
export declare const createDraftSafeSelector: import("reselect").CreateSelectorFunction<typeof weakMapMemoize, typeof weakMapMemoize, any>;
