"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutocompleteBase = void 0;
const core_1 = require("@oclif/core");
const fs = require("fs-extra");
const path = require("path");
class AutocompleteBase extends core_1.Command {
    get cliBin() {
        return this.config.bin;
    }
    get cliBinEnvVar() {
        return this.config.bin.toUpperCase().replace('-', '_');
    }
    determineShell(shell) {
        if (!shell) {
            this.error('Missing required argument shell');
        }
        else if (this.isBashOnWindows(shell)) {
            return 'bash';
        }
        else {
            return shell;
        }
    }
    errorIfWindows() {
        if (this.config.windows && !this.isBashOnWindows(this.config.shell)) {
            throw new Error('Autocomplete is not currently supported in Windows');
        }
    }
    errorIfNotSupportedShell(shell) {
        if (!shell) {
            this.error('Missing required argument shell');
        }
        this.errorIfWindows();
        if (!['bash', 'zsh'].includes(shell)) {
            throw new Error(`${shell} is not a supported shell for autocomplete`);
        }
    }
    get autocompleteCacheDir() {
        return path.join(this.config.cacheDir, 'autocomplete');
    }
    get acLogfilePath() {
        return path.join(this.config.cacheDir, 'autocomplete.log');
    }
    writeLogFile(msg) {
        const entry = `[${(new Date()).toISOString()}] ${msg}\n`;
        const fd = fs.openSync(this.acLogfilePath, 'a');
        fs.write(fd, entry);
    }
    isBashOnWindows(shell) {
        return shell.endsWith('\\bash.exe');
    }
}
exports.AutocompleteBase = AutocompleteBase;
