import type { CallExpression, Expression, ObjectExpression, SourceLocation, Identifier } from '@babel/types';
import { TaggedTemplateProcessor } from '@wyw-in-js/processor-utils';
import type { Params, Rules, TailProcessorParams, ValueCache } from '@wyw-in-js/processor-utils';
import type { IVariableContext } from '@wyw-in-js/shared';
export type WrappedNode = string | {
    node: Identifier;
    nonLinaria?: true;
    source: string;
};
export interface IProps {
    atomic?: boolean;
    class?: string;
    name: string;
    propsAsIs: boolean;
    vars?: Record<string, Expression[]>;
}
export default class StyledProcessor extends TaggedTemplateProcessor {
    #private;
    component: WrappedNode;
    constructor(params: Params, ...args: TailProcessorParams);
    get asSelector(): string;
    get value(): ObjectExpression;
    protected get tagExpression(): CallExpression;
    protected get tagExpressionArgument(): Expression;
    addInterpolation(node: Expression, precedingCss: string, source: string, unit?: string): string;
    doEvaltimeReplacement(): void;
    doRuntimeReplacement(): void;
    extractRules(valueCache: ValueCache, cssText: string, loc?: SourceLocation | null): Rules;
    toString(): string;
    protected getCustomVariableId(source: string, unit: string, precedingCss: string): string | undefined;
    protected getProps(): IProps;
    protected getTagComponentProps(props: IProps): ObjectExpression;
    protected getVariableContext(source: string, unit: string, precedingCss: string): IVariableContext;
    protected getVariableId(source: string, unit: string, precedingCss: string): string;
}
