"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/processors/css.ts
var css_exports = {};
__export(css_exports, {
  default: () => CssProcessor
});
module.exports = __toCommonJS(css_exports);
var import_processor_utils = require("@wyw-in-js/processor-utils");
var CssProcessor = class extends import_processor_utils.TaggedTemplateProcessor {
  get asSelector() {
    return this.className;
  }
  get value() {
    return this.astService.stringLiteral(this.className);
  }
  // eslint-disable-next-line class-methods-use-this
  addInterpolation(node, precedingCss, source) {
    throw new Error(
      `css tag cannot handle '${source}' as an interpolated value`
    );
  }
  doEvaltimeReplacement() {
    this.replacer(this.value, false);
  }
  doRuntimeReplacement() {
    this.replacer(this.astService.stringLiteral(this.className), false);
  }
  extractRules(valueCache, cssText, loc) {
    const rules = {};
    const selector = `.${this.className}`;
    rules[selector] = {
      cssText,
      className: this.className,
      displayName: this.displayName,
      start: loc?.start ?? null
    };
    return rules;
  }
};
//# sourceMappingURL=css.js.map