import type { Action as HistoryAction, History, Location as HistoryLocation } from 'history';
import React from 'react';
import type { BrowserRouterProps } from 'react-router-dom';
interface IonReactRouterProps extends BrowserRouterProps {
    history?: History;
}
export declare class IonReactRouter extends React.Component<IonReactRouterProps> {
    historyListenHandler?: (location: HistoryLocation, action: HistoryAction) => void;
    history: History;
    constructor(props: IonReactRouterProps);
    /**
     * history@4.x passes separate location and action
     * params. history@5.x passes location and action
     * together as a single object.
     * TODO: If support for React Router <=5 is dropped
     * this logic is no longer needed. We can just assume
     * a single object with both location and action.
     */
    handleHistoryChange(location: HistoryLocation, action: HistoryAction): void;
    registerHistoryListener(cb: (location: HistoryLocation, action: HistoryAction) => void): void;
    render(): JSX.Element;
}
export {};
