import type { Action as HistoryAction, History, Location as HistoryLocation } from 'history';
import React from 'react';
import type { BrowserRouterProps } from 'react-router-dom';
interface IonReactHashRouterProps extends BrowserRouterProps {
    history?: History;
}
export declare class IonReactHashRouter extends React.Component<IonReactHashRouterProps> {
    history: History;
    historyListenHandler?: (location: HistoryLocation, action: HistoryAction) => void;
    constructor(props: IonReactHashRouterProps);
    /**
     * history@4.x passes separate location and action
     * params. history@5.x passes location and action
     * together as a single object.
     * TODO: If support for React Router <=5 is dropped
     * this logic is no longer needed. We can just assume
     * a single object with both location and action.
     */
    handleHistoryChange(location: HistoryLocation, action: HistoryAction): void;
    registerHistoryListener(cb: (location: HistoryLocation, action: HistoryAction) => void): void;
    render(): JSX.Element;
}
export {};
