/*!
 * (C) Ionic http://ionicframework.com - MIT License
 */
import { Host, h } from "@stencil/core";
import { getIonMode } from "../../global/ionic-global";
export class Grid {
    constructor() {
        this.fixed = false;
    }
    render() {
        const mode = getIonMode(this);
        return (h(Host, { key: '03a8975bb9320192033219fc9e06fe7afa4fae4a', class: {
                [mode]: true,
                'grid-fixed': this.fixed,
            } }, h("slot", { key: '8d95abb4614e73a46a274668c13fe7c7f011c537' })));
    }
    static get is() { return "ion-grid"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["grid.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["grid.css"]
        };
    }
    static get properties() {
        return {
            "fixed": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the grid will have a fixed width based on the screen size."
                },
                "attribute": "fixed",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
}
