/// <reference types="qs" />
/// <reference types="node" />
/// <reference types="node" />
import express from "express";
import core from "express-serve-static-core";
import http from "http";
import https from "https";
type ViteConfig = {
    root: string;
    base: string;
    build: {
        outDir: string;
    };
};
declare const Config: {
    mode: "production" | "development";
    inlineViteConfig: Partial<ViteConfig> | undefined;
    viteConfigFile: string | undefined;
    ignorePaths: RegExp | ((path: string, req: express.Request) => boolean) | undefined;
    transformer: ((html: string, req: express.Request) => string | Promise<string>) | undefined;
};
type ConfigurationOptions = Partial<typeof Config>;
declare function config(config: ConfigurationOptions): void;
declare function bind(app: core.Express, server: http.Server | https.Server, callback?: () => void): Promise<void>;
declare function listen(app: core.Express, port: number, callback?: () => void): http.Server<typeof http.IncomingMessage, typeof http.ServerResponse>;
declare function build(): Promise<void>;
declare const _default: {
    config: typeof config;
    bind: typeof bind;
    listen: typeof listen;
    build: typeof build;
    static: () => express.RequestHandler<core.ParamsDictionary, any, any, import("qs").ParsedQs, Record<string, any>>;
};
export = _default;
