/**
 * @jsxImportSource solid-js
 */
import { JSX } from "solid-js";
import { ViewportComponentAttributes } from "./types";
import { VirtualizerHandle, VirtualizerProps } from "./Virtualizer";
/**
 * Methods of {@link VList}.
 */
export interface VListHandle extends VirtualizerHandle {
}
/**
 * Props of {@link VList}.
 */
export interface VListProps<T> extends Pick<VirtualizerProps<T>, "ref" | "data" | "children" | "overscan" | "itemSize" | "shift" | "horizontal" | "onScroll" | "onScrollEnd" | "onRangeChange">, ViewportComponentAttributes {
}
/**
 * Virtualized list component. See {@link VListProps} and {@link VListHandle}.
 */
export declare const VList: <T>(props: VListProps<T>) => JSX.Element;
