/**
 * @typedef Options
 *   Configuration.
 * @property {string} connectedInstance
 *   The lemmy instance the user is connected to, e.g. `"lemmy.world"`
 */
/**
 * Create an extension for `mdast-util-from-markdown` to enable GFM autolink
 * literals in markdown.
 *
 * @param {Options} options
 * @returns {FromMarkdownExtension}
 *   Extension for `mdast-util-to-markdown` to enable GFM autolink literals.
 */
export function gfmAutolinkLiteralFromMarkdown(options: Options): FromMarkdownExtension;
/**
 * Create an extension for `mdast-util-to-markdown` to enable GFM autolink
 * literals in markdown.
 *
 * @returns {ToMarkdownExtension}
 *   Extension for `mdast-util-to-markdown` to enable GFM autolink literals.
 */
export function gfmAutolinkLiteralToMarkdown(): ToMarkdownExtension;
/**
 * Configuration.
 */
export type Options = {
    /**
     *   The lemmy instance the user is connected to, e.g. `"lemmy.world"`
     */
    connectedInstance: string;
};
export type Link = import('mdast').Link;
export type PhrasingContent = import('mdast').PhrasingContent;
export type CompileContext = import('mdast-util-from-markdown').CompileContext;
export type FromMarkdownExtension = import('mdast-util-from-markdown').Extension;
export type FromMarkdownHandle = import('mdast-util-from-markdown').Handle;
export type FromMarkdownTransform = import('mdast-util-from-markdown').Transform;
export type ConstructName = import('mdast-util-to-markdown').ConstructName;
export type ToMarkdownExtension = import('mdast-util-to-markdown').Options;
export type RegExpMatchObject = import('mdast-util-find-and-replace').RegExpMatchObject;
export type ReplaceFunction = import('mdast-util-find-and-replace').ReplaceFunction;
