/**
 * This file contains a Vite loader for wyw-in-js.
 * It uses the transform.ts function to generate class names from source code,
 * returns transformed code without template literals and attaches generated source maps
 */
import type { FilterPattern } from '@rollup/pluginutils';
import type { Plugin } from 'vite';
import type { IFileReporterOptions, PluginOptions, Preprocessor } from '@wyw-in-js/transform';
type VitePluginOptions = {
    debug?: IFileReporterOptions | false | null | undefined;
    exclude?: FilterPattern;
    include?: FilterPattern;
    preprocessor?: Preprocessor;
    sourceMap?: boolean;
} & Partial<PluginOptions>;
export { Plugin };
export default function wywInJS({ debug, include, exclude, sourceMap, preprocessor, ...rest }?: VitePluginOptions): Plugin;
