"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPS = void 0;
const project_1 = require("@trapezedev/project");
async function execute(ctx, op) {
    var _a;
    const xmlOp = op;
    const entries = xmlOp.value;
    if (!ctx.project.ios) {
        return;
    }
    for (const entry of entries) {
        let filename = entry.file;
        let jsonFile = null;
        jsonFile = (_a = ctx.project.ios) === null || _a === void 0 ? void 0 : _a.getProjectFile(filename, (filename) => new project_1.JsonFile(filename, ctx.project.vfs));
        if (!jsonFile) {
            return;
        }
        await jsonFile.load();
        if (entry.set) {
            jsonFile.set(entry.set);
        }
        if (entry.merge) {
            jsonFile.merge(entry.merge);
        }
    }
}
exports.default = execute;
exports.OPS = [
    'ios.json'
];
//# sourceMappingURL=json.js.map