import type { WYWEvalMeta } from '@wyw-in-js/shared';
import React from 'react';
import type { CSSProperties } from '@linaria/core';
export type NoInfer<A> = [A][A extends any ? 0 : never];
type Component<TProps> = ((props: TProps) => unknown) | {
    new (props: TProps): unknown;
};
type Has<T, TObj> = [T] extends [TObj] ? T : T & TObj;
export declare const omit: <T extends Record<string, unknown>, TKeys extends keyof T>(obj: T, keys: TKeys[]) => Omit<T, TKeys>;
declare function styled(componentWithStyle: () => any): (error: 'The target component should have a className prop') => void;
declare function styled<TProps extends Has<TMustHave, {
    style?: React.CSSProperties;
}>, TMustHave extends {
    style?: React.CSSProperties;
}, TConstructor extends Component<TProps>>(componentWithStyle: TConstructor & Component<TProps>): ComponentStyledTagWithInterpolation<TProps, TConstructor>;
declare function styled<TProps extends Has<TMustHave, {
    className?: string;
}>, TMustHave extends {
    className?: string;
}, TConstructor extends Component<TProps>>(componentWithoutStyle: TConstructor & Component<TProps>): ComponentStyledTagWithoutInterpolation<TConstructor>;
declare function styled<TName extends keyof JSX.IntrinsicElements>(tag: TName): HtmlStyledTag<TName>;
declare function styled(component: 'The target component should have a className prop'): never;
export type StyledComponent<T> = WYWEvalMeta & ([T] extends [React.FunctionComponent<any>] ? T : React.FunctionComponent<T & {
    as?: React.ElementType;
}>);
type StaticPlaceholder = string | number | CSSProperties | WYWEvalMeta;
export type HtmlStyledTag<TName extends keyof JSX.IntrinsicElements> = <TAdditionalProps = Record<never, unknown>>(strings: TemplateStringsArray, ...exprs: Array<StaticPlaceholder | ((props: JSX.IntrinsicElements[TName] & Omit<TAdditionalProps, never>) => string | number)>) => StyledComponent<JSX.IntrinsicElements[TName] & TAdditionalProps>;
type ComponentStyledTagWithoutInterpolation<TOrigCmp> = (strings: TemplateStringsArray, ...exprs: Array<StaticPlaceholder | ((props: 'The target component should have a style prop') => never)>) => WYWEvalMeta & TOrigCmp;
type ComponentStyledTagWithInterpolation<TTrgProps, TOrigCmp> = <OwnProps = {}>(strings: TemplateStringsArray, ...exprs: Array<StaticPlaceholder | ((props: NoInfer<OwnProps & TTrgProps>) => string | number)>) => keyof OwnProps extends never ? WYWEvalMeta & TOrigCmp : StyledComponent<OwnProps & TTrgProps>;
export type StyledJSXIntrinsics = {
    readonly [P in keyof JSX.IntrinsicElements]: HtmlStyledTag<P>;
};
export type Styled = typeof styled & StyledJSXIntrinsics;
declare const _default: Styled;
export default _default;
