/*!
 * (C) Ionic http://ionicframework.com - MIT License
 */
export const navLink = (el, routerDirection, component, componentProps, routerAnimation) => {
    const nav = el.closest('ion-nav');
    if (nav) {
        if (routerDirection === 'forward') {
            if (component !== undefined) {
                return nav.push(component, componentProps, { skipIfBusy: true, animationBuilder: routerAnimation });
            }
        }
        else if (routerDirection === 'root') {
            if (component !== undefined) {
                return nav.setRoot(component, componentProps, { skipIfBusy: true, animationBuilder: routerAnimation });
            }
        }
        else if (routerDirection === 'back') {
            return nav.pop({ skipIfBusy: true, animationBuilder: routerAnimation });
        }
    }
    return Promise.resolve(false);
};
