/*!
 * (C) Ionic http://ionicframework.com - MIT License
 */
'use strict';

const helpers = require('./helpers-76bb7efb.js');
const dir = require('./dir-94c21456.js');
const index = require('./index-d1b59ffa.js');
require('./gesture-controller-c40c045a.js');

const createSwipeBackGesture = (el, canStartHandler, onStartHandler, onMoveHandler, onEndHandler) => {
    const win = el.ownerDocument.defaultView;
    let rtl = dir.isRTL(el);
    /**
     * Determine if a gesture is near the edge
     * of the screen. If true, then the swipe
     * to go back gesture should proceed.
     */
    const isAtEdge = (detail) => {
        const threshold = localStorage.getItem('FULL_SWIPE_BACK') ? win.innerWidth : 60;
        const { startX } = detail;
        if (rtl) {
            return startX >= win.innerWidth - threshold;
        }
        return startX <= threshold;
    };
    const getDeltaX = (detail) => {
        return rtl ? -detail.deltaX : detail.deltaX;
    };
    const getVelocityX = (detail) => {
        return rtl ? -detail.velocityX : detail.velocityX;
    };
    const canStart = (detail) => {
        /**
         * The user's locale can change mid-session,
         * so we need to check text direction at
         * the beginning of every gesture.
         */
        rtl = dir.isRTL(el);
        return isAtEdge(detail) && canStartHandler();
    };
    const onMove = (detail) => {
        // set the transition animation's progress
        const delta = getDeltaX(detail);
        const stepValue = delta / win.innerWidth;
        onMoveHandler(stepValue);
    };
    const onEnd = (detail) => {
        // the swipe back gesture has ended
        const delta = getDeltaX(detail);
        const width = win.innerWidth;
        const stepValue = delta / width;
        const velocity = getVelocityX(detail);
        const z = width / 2.0;
        const shouldComplete = velocity >= 0 && (velocity > 0.2 || delta > z);
        const missing = shouldComplete ? 1 - stepValue : stepValue;
        const missingDistance = missing * width;
        let realDur = 0;
        if (missingDistance > 5) {
            const dur = missingDistance / Math.abs(velocity);
            realDur = Math.min(dur, 200);
        }
        onEndHandler(shouldComplete, stepValue <= 0 ? 0.01 : helpers.clamp(0, stepValue, 0.9999), realDur);
    };
    return index.createGesture({
        el,
        gestureName: 'goback-swipe',
        /**
         * Swipe to go back should have priority over other horizontal swipe
         * gestures. These gestures have a priority of 100 which is why 101 was chosen here.
         */
        gesturePriority: 101,
        threshold: 10,
        canStart,
        onStart: onStartHandler,
        onMove,
        onEnd,
    });
};

exports.createSwipeBackGesture = createSwipeBackGesture;
