import { isatty } from 'node:tty';
import { createRequire } from 'node:module';
import util from 'node:util';
import timers from 'node:timers';
import { performance } from 'node:perf_hooks';
import { startTests } from '@vitest/runner';
import { setupColors, createColors } from '@vitest/utils';
import { V as VitestSnapshotEnvironment, s as setupChaiConfig, r as resolveTestRunner } from './vendor/index.h0j9y5vy.js';
import { s as startCoverageInsideWorker, a as stopCoverageInsideWorker } from './vendor/coverage.v6aD8iAh.js';
import { g as getWorkerState } from './vendor/global.L7JRz1qU.js';
import { i as index } from './vendor/index.VL3WbvjT.js';
import { setupCommonEnv } from './browser.js';
import 'chai';
import '@vitest/snapshot/environment';
import 'pathe';
import './paths.js';
import 'node:url';
import './vendor/rpc.Bl-ysZIr.js';
import './vendor/benchmark.WVm6DARl.js';
import '@vitest/runner/utils';
import './vendor/index.XU72Rmy8.js';
import 'std-env';
import './vendor/run-once.X3E7xx3F.js';
import './vendor/vi.JXuS6emb.js';
import './vendor/_commonjsHelpers.jjO7Zipk.js';
import '@vitest/expect';
import '@vitest/snapshot';
import '@vitest/utils/error';
import './vendor/tasks.IknbGB2n.js';
import '@vitest/utils/source-map';
import './vendor/date.Ns1pGd_X.js';
import '@vitest/spy';

async function run(files, config, executor) {
  const workerState = getWorkerState();
  await setupCommonEnv(config);
  Object.defineProperty(globalThis, "__vitest_index__", {
    value: index,
    enumerable: false
  });
  config.snapshotOptions.snapshotEnvironment = new VitestSnapshotEnvironment(workerState.rpc);
  setupColors(createColors(isatty(1)));
  if (workerState.environment.transformMode === "web") {
    const _require = createRequire(import.meta.url);
    _require.extensions[".css"] = () => ({});
    _require.extensions[".scss"] = () => ({});
    _require.extensions[".sass"] = () => ({});
    _require.extensions[".less"] = () => ({});
  }
  globalThis.__vitest_required__ = {
    util,
    timers
  };
  await startCoverageInsideWorker(config.coverage, executor);
  if (config.chaiConfig)
    setupChaiConfig(config.chaiConfig);
  const runner = await resolveTestRunner(config, executor);
  workerState.durations.prepare = performance.now() - workerState.durations.prepare;
  for (const file of files) {
    workerState.filepath = file;
    await startTests([file], runner);
    workerState.filepath = void 0;
  }
  await stopCoverageInsideWorker(config.coverage, executor);
}

export { run };
