import require$$0 from 'fs';
import p from 'path';
import { g as getDefaultExportFromCjs } from '../vendor/_commonjsHelpers.jjO7Zipk.js';
import require$$0$1 from 'util';
import execa from 'execa';

var findUp$1 = {exports: {}};

var locatePath = {exports: {}};

class Node {
	/// value;
	/// next;

	constructor(value) {
		this.value = value;

		// TODO: Remove this when targeting Node.js 12.
		this.next = undefined;
	}
}

let Queue$1 = class Queue {
	// TODO: Use private class fields when targeting Node.js 12.
	// #_head;
	// #_tail;
	// #_size;

	constructor() {
		this.clear();
	}

	enqueue(value) {
		const node = new Node(value);

		if (this._head) {
			this._tail.next = node;
			this._tail = node;
		} else {
			this._head = node;
			this._tail = node;
		}

		this._size++;
	}

	dequeue() {
		const current = this._head;
		if (!current) {
			return;
		}

		this._head = this._head.next;
		this._size--;
		return current.value;
	}

	clear() {
		this._head = undefined;
		this._tail = undefined;
		this._size = 0;
	}

	get size() {
		return this._size;
	}

	* [Symbol.iterator]() {
		let current = this._head;

		while (current) {
			yield current.value;
			current = current.next;
		}
	}
};

var yoctoQueue = Queue$1;

const Queue = yoctoQueue;

const pLimit$1 = concurrency => {
	if (!((Number.isInteger(concurrency) || concurrency === Infinity) && concurrency > 0)) {
		throw new TypeError('Expected `concurrency` to be a number from 1 and up');
	}

	const queue = new Queue();
	let activeCount = 0;

	const next = () => {
		activeCount--;

		if (queue.size > 0) {
			queue.dequeue()();
		}
	};

	const run = async (fn, resolve, ...args) => {
		activeCount++;

		const result = (async () => fn(...args))();

		resolve(result);

		try {
			await result;
		} catch {}

		next();
	};

	const enqueue = (fn, resolve, ...args) => {
		queue.enqueue(run.bind(null, fn, resolve, ...args));

		(async () => {
			// This function needs to wait until the next microtask before comparing
			// `activeCount` to `concurrency`, because `activeCount` is updated asynchronously
			// when the run function is dequeued and called. The comparison in the if-statement
			// needs to happen asynchronously as well to get an up-to-date value for `activeCount`.
			await Promise.resolve();

			if (activeCount < concurrency && queue.size > 0) {
				queue.dequeue()();
			}
		})();
	};

	const generator = (fn, ...args) => new Promise(resolve => {
		enqueue(fn, resolve, ...args);
	});

	Object.defineProperties(generator, {
		activeCount: {
			get: () => activeCount
		},
		pendingCount: {
			get: () => queue.size
		},
		clearQueue: {
			value: () => {
				queue.clear();
			}
		}
	});

	return generator;
};

var pLimit_1 = pLimit$1;

const pLimit = pLimit_1;

class EndError extends Error {
	constructor(value) {
		super();
		this.value = value;
	}
}

// The input can also be a promise, so we await it
const testElement = async (element, tester) => tester(await element);

// The input can also be a promise, so we `Promise.all()` them both
const finder = async element => {
	const values = await Promise.all(element);
	if (values[1] === true) {
		throw new EndError(values[0]);
	}

	return false;
};

const pLocate$1 = async (iterable, tester, options) => {
	options = {
		concurrency: Infinity,
		preserveOrder: true,
		...options
	};

	const limit = pLimit(options.concurrency);

	// Start all the promises concurrently with optional limit
	const items = [...iterable].map(element => [element, limit(testElement, element, tester)]);

	// Check the promises either serially or concurrently
	const checkLimit = pLimit(options.preserveOrder ? 1 : Infinity);

	try {
		await Promise.all(items.map(element => checkLimit(finder, element)));
	} catch (error) {
		if (error instanceof EndError) {
			return error.value;
		}

		throw error;
	}
};

var pLocate_1 = pLocate$1;

const path = p;
const fs$1 = require$$0;
const {promisify: promisify$1} = require$$0$1;
const pLocate = pLocate_1;

const fsStat = promisify$1(fs$1.stat);
const fsLStat = promisify$1(fs$1.lstat);

const typeMappings = {
	directory: 'isDirectory',
	file: 'isFile'
};

function checkType({type}) {
	if (type in typeMappings) {
		return;
	}

	throw new Error(`Invalid type specified: ${type}`);
}

const matchType = (type, stat) => type === undefined || stat[typeMappings[type]]();

locatePath.exports = async (paths, options) => {
	options = {
		cwd: process.cwd(),
		type: 'file',
		allowSymlinks: true,
		...options
	};

	checkType(options);

	const statFn = options.allowSymlinks ? fsStat : fsLStat;

	return pLocate(paths, async path_ => {
		try {
			const stat = await statFn(path.resolve(options.cwd, path_));
			return matchType(options.type, stat);
		} catch {
			return false;
		}
	}, options);
};

locatePath.exports.sync = (paths, options) => {
	options = {
		cwd: process.cwd(),
		allowSymlinks: true,
		type: 'file',
		...options
	};

	checkType(options);

	const statFn = options.allowSymlinks ? fs$1.statSync : fs$1.lstatSync;

	for (const path_ of paths) {
		try {
			const stat = statFn(path.resolve(options.cwd, path_));

			if (matchType(options.type, stat)) {
				return path_;
			}
		} catch {}
	}
};

var locatePathExports = locatePath.exports;

var pathExists = {exports: {}};

const fs = require$$0;
const {promisify} = require$$0$1;

const pAccess = promisify(fs.access);

pathExists.exports = async path => {
	try {
		await pAccess(path);
		return true;
	} catch (_) {
		return false;
	}
};

pathExists.exports.sync = path => {
	try {
		fs.accessSync(path);
		return true;
	} catch (_) {
		return false;
	}
};

var pathExistsExports = pathExists.exports;

(function (module) {
	const path = p;
	const locatePath = locatePathExports;
	const pathExists = pathExistsExports;

	const stop = Symbol('findUp.stop');

	module.exports = async (name, options = {}) => {
		let directory = path.resolve(options.cwd || '');
		const {root} = path.parse(directory);
		const paths = [].concat(name);

		const runMatcher = async locateOptions => {
			if (typeof name !== 'function') {
				return locatePath(paths, locateOptions);
			}

			const foundPath = await name(locateOptions.cwd);
			if (typeof foundPath === 'string') {
				return locatePath([foundPath], locateOptions);
			}

			return foundPath;
		};

		// eslint-disable-next-line no-constant-condition
		while (true) {
			// eslint-disable-next-line no-await-in-loop
			const foundPath = await runMatcher({...options, cwd: directory});

			if (foundPath === stop) {
				return;
			}

			if (foundPath) {
				return path.resolve(directory, foundPath);
			}

			if (directory === root) {
				return;
			}

			directory = path.dirname(directory);
		}
	};

	module.exports.sync = (name, options = {}) => {
		let directory = path.resolve(options.cwd || '');
		const {root} = path.parse(directory);
		const paths = [].concat(name);

		const runMatcher = locateOptions => {
			if (typeof name !== 'function') {
				return locatePath.sync(paths, locateOptions);
			}

			const foundPath = name(locateOptions.cwd);
			if (typeof foundPath === 'string') {
				return locatePath.sync([foundPath], locateOptions);
			}

			return foundPath;
		};

		// eslint-disable-next-line no-constant-condition
		while (true) {
			const foundPath = runMatcher({...options, cwd: directory});

			if (foundPath === stop) {
				return;
			}

			if (foundPath) {
				return path.resolve(directory, foundPath);
			}

			if (directory === root) {
				return;
			}

			directory = path.dirname(directory);
		}
	};

	module.exports.exists = pathExists;

	module.exports.sync.exists = pathExists.sync;

	module.exports.stop = stop; 
} (findUp$1));

var findUpExports = findUp$1.exports;
var findUp = /*@__PURE__*/getDefaultExportFromCjs(findUpExports);

// src/detect.ts
var AGENTS = ["pnpm", "yarn", "npm", "pnpm@6", "yarn@berry", "bun"];
var LOCKS = {
  "bun.lockb": "bun",
  "pnpm-lock.yaml": "pnpm",
  "yarn.lock": "yarn",
  "package-lock.json": "npm",
  "npm-shrinkwrap.json": "npm"
};
async function detectPackageManager(cwd = process.cwd()) {
  let agent = null;
  const lockPath = await findUp(Object.keys(LOCKS), { cwd });
  let packageJsonPath;
  if (lockPath)
    packageJsonPath = p.resolve(lockPath, "../package.json");
  else
    packageJsonPath = await findUp("package.json", { cwd });
  if (packageJsonPath && require$$0.existsSync(packageJsonPath)) {
    try {
      const pkg = JSON.parse(require$$0.readFileSync(packageJsonPath, "utf8"));
      if (typeof pkg.packageManager === "string") {
        const [name, version] = pkg.packageManager.split("@");
        if (name === "yarn" && parseInt(version) > 1)
          agent = "yarn@berry";
        else if (name === "pnpm" && parseInt(version) < 7)
          agent = "pnpm@6";
        else if (name in AGENTS)
          agent = name;
        else
          console.warn("[ni] Unknown packageManager:", pkg.packageManager);
      }
    } catch {
    }
  }
  if (!agent && lockPath)
    agent = LOCKS[p.basename(lockPath)];
  return agent;
}
async function installPackage(names, options = {}) {
  const detectedAgent = options.packageManager || await detectPackageManager(options.cwd) || "npm";
  const [agent] = detectedAgent.split("@");
  if (!Array.isArray(names))
    names = [names];
  const args = options.additionalArgs || [];
  if (options.preferOffline) {
    if (detectedAgent === "yarn@berry")
      args.unshift("--cached");
    else
      args.unshift("--prefer-offline");
  }
  return execa(
    agent,
    [
      agent === "yarn" ? "add" : "install",
      options.dev ? "-D" : "",
      ...args,
      ...names
    ].filter(Boolean),
    {
      stdio: options.silent ? "ignore" : "inherit",
      cwd: options.cwd
    }
  );
}

export { detectPackageManager, installPackage };
