export { processError, startTests } from '@vitest/runner';
import { setSafeTimers } from '@vitest/utils';
import { a as resetRunOnceCounter } from './vendor/run-once.X3E7xx3F.js';
export { g as getCoverageProvider, s as startCoverageInsideWorker, a as stopCoverageInsideWorker, t as takeCoverageInsideWorker } from './vendor/coverage.v6aD8iAh.js';
import './vendor/global.L7JRz1qU.js';

let globalSetup = false;
async function setupCommonEnv(config) {
  resetRunOnceCounter();
  setupDefines(config.defines);
  if (globalSetup)
    return;
  globalSetup = true;
  setSafeTimers();
  if (config.globals)
    (await import('./chunks/integrations-globals.eip0xL77.js')).registerApiGlobally();
}
function setupDefines(defines) {
  for (const key in defines)
    globalThis[key] = defines[key];
}
async function loadDiffConfig(config, executor) {
  if (typeof config.diff !== "string")
    return;
  const diffModule = await executor.executeId(config.diff);
  if (diffModule && typeof diffModule.default === "object" && diffModule.default != null)
    return diffModule.default;
  else
    throw new Error(`invalid diff config file ${config.diff}. Must have a default export with config object`);
}

export { loadDiffConfig, setupCommonEnv };
