import type { Context } from './context';
export declare const PREFIX = "[modern-screenshot]";
export declare const IN_BROWSER: boolean;
export declare const SUPPORT_WEB_WORKER: boolean;
export declare const SUPPORT_ATOB: boolean;
export declare const SUPPORT_BTOA: boolean;
export declare const USER_AGENT: string;
export declare const IN_CHROME: boolean;
export declare const IN_SAFARI: boolean;
export declare const IN_FIREFOX: boolean;
export declare const isContext: <T extends Node>(value: any) => value is Context<T>;
export declare const isCssFontFaceRule: (rule: CSSRule) => rule is CSSFontFaceRule;
export declare const isCSSImportRule: (rule: CSSRule) => rule is CSSImportRule;
export declare const isElementNode: (node: Node) => node is Element;
export declare const isSVGElementNode: (node: Element) => node is SVGElement;
export declare const isSVGImageElementNode: (node: Element) => node is SVGImageElement;
export declare const isSVGUseElementNode: (node: Element) => node is SVGUseElement;
export declare const isHTMLElementNode: (node: Node) => node is HTMLElement;
export declare const isCommentNode: (node: Node) => node is Text;
export declare const isTextNode: (node: Node) => node is Text;
export declare const isImageElement: (node: Element) => node is HTMLImageElement;
export declare const isVideoElement: (node: Element) => node is HTMLVideoElement;
export declare const isCanvasElement: (node: Element) => node is HTMLCanvasElement;
export declare const isTextareaElement: (node: Element) => node is HTMLTextAreaElement;
export declare const isInputElement: (node: Element) => node is HTMLInputElement;
export declare const isStyleElement: (node: Element) => node is HTMLStyleElement;
export declare const isScriptElement: (node: Element) => node is HTMLScriptElement;
export declare const isSelectElement: (node: Element) => node is HTMLSelectElement;
export declare const isSlotElement: (node: Element) => node is HTMLSlotElement;
export declare const isIFrameElement: (node: Element) => node is HTMLIFrameElement;
export declare const consoleWarn: (...args: any[]) => void;
export declare const consoleTime: (label: string) => void;
export declare const consoleTimeEnd: (label: string) => void;
export declare const supportWebp: (ownerDocument?: Document) => boolean | undefined;
export declare const isDataUrl: (url: string) => boolean;
export declare function resolveUrl(url: string, baseUrl: string | null): string;
export declare function getDocument<T extends Node>(target?: T | null): Document;
export declare const XMLNS = "http://www.w3.org/2000/svg";
export declare function createSvg(width: number, height: number, ownerDocument?: Document | null): SVGSVGElement;
export declare function svgToDataUrl(svg: SVGElement, removeControlCharacter: boolean): string;
export declare function canvasToBlob(canvas: HTMLCanvasElement, type?: string, quality?: number): Promise<Blob>;
export declare function dataUrlToBlob(dataUrl: string): Blob;
export declare function readBlob(blob: Blob, type: 'dataUrl'): Promise<string>;
export declare function readBlob(blob: Blob, type: 'arrayBuffer'): Promise<ArrayBuffer>;
export declare const blobToDataUrl: (blob: Blob) => Promise<string>;
export declare const blobToArrayBuffer: (blob: Blob) => Promise<ArrayBuffer>;
export declare function createImage(url: string, ownerDocument?: Document | null): HTMLImageElement;
type Media = HTMLVideoElement | HTMLImageElement | SVGImageElement;
interface LoadMediaOptions {
    ownerDocument?: Document;
    timeout?: number;
    onError?: (error: Error) => void;
}
export declare function loadMedia<T extends Media>(media: T, options?: LoadMediaOptions): Promise<T>;
export declare function loadMedia(media: string, options?: LoadMediaOptions): Promise<HTMLImageElement>;
export declare function waitUntilLoad(node: Node, timeout: number): Promise<void>;
export declare const uuid: () => string;
export declare function splitFontFamily(fontFamily?: string): undefined | string[];
export {};
