import type { Action, Dispatch, UnknownAction } from 'redux';
import type { ThunkDispatch } from 'redux-thunk';
import type { ListenerMiddlewareInstance, CreateListenerMiddlewareOptions, TypedAddListener, TypedCreateListenerEntry, TypedRemoveListener } from './types';
export { TaskAbortError } from './exceptions';
export type { ListenerEffect, ListenerMiddleware, ListenerEffectAPI, ListenerMiddlewareInstance, CreateListenerMiddlewareOptions, ListenerErrorHandler, TypedStartListening, TypedAddListener, TypedStopListening, TypedRemoveListener, UnsubscribeListener, UnsubscribeListenerOptions, ForkedTaskExecutor, ForkedTask, ForkedTaskAPI, AsyncTaskExecutor, SyncTaskExecutor, TaskCancelled, TaskRejected, TaskResolved, TaskResult, } from './types';
/** Accepts the possible options for creating a listener, and returns a formatted listener entry */
export declare const createListenerEntry: TypedCreateListenerEntry<unknown>;
/**
 * @public
 */
export declare const addListener: TypedAddListener<unknown>;
/**
 * @public
 */
export declare const clearAllListeners: import("../createAction").ActionCreatorWithoutPayload<"listenerMiddleware/removeAll">;
/**
 * @public
 */
export declare const removeListener: TypedRemoveListener<unknown>;
/**
 * @public
 */
export declare function createListenerMiddleware<S = unknown, D extends Dispatch<Action> = ThunkDispatch<S, unknown, UnknownAction>, ExtraArgument = unknown>(middlewareOptions?: CreateListenerMiddlewareOptions<ExtraArgument>): ListenerMiddlewareInstance<S, D, ExtraArgument>;
