import React from 'react';
export interface IonLifeCycleContextInterface {
    onIonViewWillEnter: (callback: () => void) => void;
    ionViewWillEnter: () => void;
    onIonViewDidEnter: (callback: () => void) => void;
    ionViewDidEnter: () => void;
    onIonViewWillLeave: (callback: () => void) => void;
    ionViewWillLeave: () => void;
    onIonViewDidLeave: (callback: () => void) => void;
    ionViewDidLeave: () => void;
    cleanupIonViewWillEnter: (callback: () => void) => void;
    cleanupIonViewDidEnter: (callback: () => void) => void;
    cleanupIonViewWillLeave: (callback: () => void) => void;
    cleanupIonViewDidLeave: (callback: () => void) => void;
}
export declare const IonLifeCycleContext: React.Context<IonLifeCycleContextInterface>;
export interface LifeCycleCallback {
    (): void | (() => void | undefined);
    id?: number;
}
export interface LifeCycleDestructor {
    id: number;
    destructor: ReturnType<LifeCycleCallback>;
}
export declare const DefaultIonLifeCycleContext: {
    new (): {
        ionViewWillEnterCallbacks: LifeCycleCallback[];
        ionViewDidEnterCallbacks: LifeCycleCallback[];
        ionViewWillLeaveCallbacks: LifeCycleCallback[];
        ionViewDidLeaveCallbacks: LifeCycleCallback[];
        componentCanBeDestroyedCallback?: (() => void) | undefined;
        ionViewWillEnterDestructorCallbacks: LifeCycleDestructor[];
        ionViewDidEnterDestructorCallbacks: LifeCycleDestructor[];
        ionViewWillLeaveDestructorCallbacks: LifeCycleDestructor[];
        ionViewDidLeaveDestructorCallbacks: LifeCycleDestructor[];
        onIonViewWillEnter(callback: LifeCycleCallback): void;
        teardownCallback(callback: LifeCycleCallback, callbacks: any[]): void;
        /**
         * Tears down the user-provided ionViewWillEnter lifecycle callback.
         * This is the same behavior as React's useEffect hook. The callback
         * is invoked when the component is unmounted.
         */
        cleanupIonViewWillEnter(callback: LifeCycleCallback): void;
        /**
         * Tears down the user-provided ionViewDidEnter lifecycle callback.
         * This is the same behavior as React's useEffect hook. The callback
         * is invoked when the component is unmounted.
         */
        cleanupIonViewDidEnter(callback: LifeCycleCallback): void;
        /**
         * Tears down the user-provided ionViewWillLeave lifecycle callback.
         * This is the same behavior as React's useEffect hook. The callback
         * is invoked when the component is unmounted.
         */
        cleanupIonViewWillLeave(callback: LifeCycleCallback): void;
        /**
         * Tears down the user-provided ionViewDidLeave lifecycle callback.
         * This is the same behavior as React's useEffect hook. The callback
         * is invoked when the component is unmounted.
         */
        cleanupIonViewDidLeave(callback: LifeCycleCallback): void;
        ionViewWillEnter(): void;
        onIonViewDidEnter(callback: LifeCycleCallback): void;
        ionViewDidEnter(): void;
        onIonViewWillLeave(callback: LifeCycleCallback): void;
        ionViewWillLeave(): void;
        onIonViewDidLeave(callback: LifeCycleCallback): void;
        ionViewDidLeave(): void;
        onComponentCanBeDestroyed(callback: () => void): void;
        componentCanBeDestroyed(): void;
    };
};
