import type { Action as HistoryAction, Location as HistoryLocation, MemoryHistory } from 'history';
import React from 'react';
import type { MemoryRouterProps } from 'react-router';
interface IonReactMemoryRouterProps extends MemoryRouterProps {
    history: MemoryHistory;
}
export declare class IonReactMemoryRouter extends React.Component<IonReactMemoryRouterProps> {
    history: MemoryHistory;
    historyListenHandler?: (location: HistoryLocation, action: HistoryAction) => void;
    constructor(props: IonReactMemoryRouterProps);
    /**
     * history@4.x passes separate location and action
     * params. history@5.x passes location and action
     * together as a single object.
     * TODO: If support for React Router <=5 is dropped
     * this logic is no longer needed. We can just assume
     * a single object with both location and action.
     */
    handleHistoryChange(location: HistoryLocation, action: HistoryAction): void;
    registerHistoryListener(cb: (location: HistoryLocation, action: HistoryAction) => void): void;
    render(): JSX.Element;
}
export {};
