import React, { MutableRefObject, createContext, useRef } from "react";
import { PostCommentItem } from "./PostCommentFeed";

type ItemsRef = MutableRefObject<PostCommentItem[] | undefined>;

interface IFeedContext {
  setItemsRef: (ref: ItemsRef | undefined) => void;

  /**
   * yodawg
   */
  itemsRefRef: React.MutableRefObject<ItemsRef | undefined> | undefined;
}

export const FeedContext = createContext<IFeedContext>({
  setItemsRef: () => undefined,
  itemsRefRef: undefined,
});

interface FeedContextProviderProps {
  children: React.ReactNode;
}

export default function FeedContextProvider({
  children,
}: FeedContextProviderProps) {
  const itemsRef = useRef<ItemsRef | undefined>();

  return (
    <FeedContext.Provider
      value={{
        setItemsRef: (ref) => (itemsRef.current = ref),
        itemsRefRef: itemsRef,
      }}
    >
      {children}
    </FeedContext.Provider>
  );
}
