/*!
 * (C) Ionic http://ionicframework.com - MIT License
 */
import { expect } from "@playwright/test";
import { configs, test } from "../../../../utils/test/playwright/index";
/**
 * This behavior does not vary across directions
 */
configs({ directions: ['ltr'] }).forEach(({ title, screenshot, config }) => {
  test.describe(title('item: disabled state'), () => {
    test('should not have visual regressions', async ({ page }) => {
      await page.goto(`/src/components/item/test/disabled`, config);
      await page.setIonViewport();
      // TODO: FW-4037 - Fix label color inconsistency between disabled controls
      await expect(page).toHaveScreenshot(screenshot(`item-disabled-diff`));
    });
  });
});
