"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
function useFetch(url, options) {
    var _this = this;
    var cache = (0, react_1.useRef)({});
    var cancelRequest = (0, react_1.useRef)(false);
    var initialState = {
        error: undefined,
        data: undefined,
    };
    var fetchReducer = function (state, action) {
        switch (action.type) {
            case 'loading':
                return __assign({}, initialState);
            case 'fetched':
                return __assign(__assign({}, initialState), { data: action.payload });
            case 'error':
                return __assign(__assign({}, initialState), { error: action.payload });
            default:
                return state;
        }
    };
    var _a = (0, react_1.useReducer)(fetchReducer, initialState), state = _a[0], dispatch = _a[1];
    (0, react_1.useEffect)(function () {
        if (!url)
            return;
        cancelRequest.current = false;
        var fetchData = function () { return __awaiter(_this, void 0, void 0, function () {
            var response, data, error_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        dispatch({ type: 'loading' });
                        if (cache.current[url]) {
                            dispatch({ type: 'fetched', payload: cache.current[url] });
                            return [2];
                        }
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 4, , 5]);
                        return [4, fetch(url, options)];
                    case 2:
                        response = _a.sent();
                        if (!response.ok) {
                            throw new Error(response.statusText);
                        }
                        return [4, response.json()];
                    case 3:
                        data = (_a.sent());
                        cache.current[url] = data;
                        if (cancelRequest.current)
                            return [2];
                        dispatch({ type: 'fetched', payload: data });
                        return [3, 5];
                    case 4:
                        error_1 = _a.sent();
                        if (cancelRequest.current)
                            return [2];
                        dispatch({ type: 'error', payload: error_1 });
                        return [3, 5];
                    case 5: return [2];
                }
            });
        }); };
        void fetchData();
        return function () {
            cancelRequest.current = true;
        };
    }, [url]);
    return state;
}
exports.default = useFetch;
