"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chalk_1 = __importDefault(require("chalk"));
const testMode = !!+process.env.PAG_TEST_MODE;
const logger = (prefix, options) => {
    const isLogEnabled = options && options.hasOwnProperty('log') ? options.log : true;
    const getTime = () => {
        return chalk_1.default.inverse(new Date().toLocaleTimeString());
    };
    const getPrefix = () => {
        return prefix ? chalk_1.default.gray(prefix) : '';
    };
    /* eslint-disable no-console */
    const raw = (...args) => {
        if (!isLogEnabled)
            return;
        console.log(...args);
    };
    const log = (...args) => {
        if (testMode || !isLogEnabled)
            return;
        console.log(getTime(), getPrefix(), ...args);
    };
    const warn = (...args) => {
        if (testMode || !isLogEnabled)
            return;
        console.warn(getTime(), getPrefix(), chalk_1.default.yellow(...args), '🤔');
    };
    const trace = (...args) => {
        if (testMode || !isLogEnabled)
            return;
        console.trace(getTime(), getPrefix(), ...args);
    };
    const error = (...args) => {
        console.error(getTime(), getPrefix(), chalk_1.default.red(...args), '😭');
    };
    const success = (...args) => {
        if (testMode || !isLogEnabled)
            return;
        console.log(getTime(), getPrefix(), chalk_1.default.green(...args), '🙌');
    };
    /* eslint-enable no-console */
    return {
        raw,
        log,
        warn,
        trace,
        error,
        success,
    };
};
exports.default = logger;
//# sourceMappingURL=logger.js.map