"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const os_1 = __importDefault(require("os"));
const constants_1 = __importDefault(require("../config/constants"));
const normalizeOnlyFlagPairs = (flag1Key, flag2Key, opts, logger) => {
    const stripOnly = (key) => key.replace('Only', '');
    if (opts[flag1Key] && opts[flag2Key]) {
        logger.warn(`Hmm, you want to _only_ generate both ${stripOnly(flag1Key)} and ${stripOnly(flag2Key)} set. Ignoring --x-only settings as this is default behavior`);
        return {
            [flag1Key]: false,
            [flag2Key]: false,
        };
    }
    return {};
};
const normalizeOutput = (output) => {
    if (!output) {
        return '.';
    }
    return output;
};
const getDefaultOptions = () => {
    const flags = constants_1.default.FLAGS;
    // TODO: replace Object.keys typecasting when it can be derived as a type
    // https://github.com/microsoft/TypeScript/pull/12253#issuecomment-263132208
    return Object.keys(flags)
        .filter((flagKey) => flags[flagKey].hasOwnProperty('default'))
        .reduce((acc, curr) => {
        return Object.assign(Object.assign({}, acc), { [curr]: flags[curr].default });
    }, {});
};
const normalizeSandboxOption = (noSandbox, logger) => {
    let sandboxDisabled = false;
    if (noSandbox) {
        if (os_1.default.platform() !== 'linux') {
            logger.warn('Disabling sandbox is only relevant on Linux platforms, request declined!');
        }
        else {
            sandboxDisabled = true;
        }
    }
    return {
        noSandbox: sandboxDisabled,
    };
};
exports.default = {
    normalizeOnlyFlagPairs,
    normalizeOutput,
    getDefaultOptions,
    normalizeSandboxOption,
};
//# sourceMappingURL=flags.js.map