"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _LemmyHttp_instances, _LemmyHttp_apiUrl, _LemmyHttp_headers, _LemmyHttp_pictrsUrl, _LemmyHttp_fetchFunction, _LemmyHttp_buildFullUrl, _LemmyHttp_wrapper;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LemmyHttp = void 0;
const cross_fetch_1 = __importDefault(require("cross-fetch"));
const form_data_1 = __importDefault(require("form-data"));
const other_types_1 = require("./other_types");
var HttpType;
(function (HttpType) {
    HttpType["Get"] = "GET";
    HttpType["Post"] = "POST";
    HttpType["Put"] = "PUT";
})(HttpType || (HttpType = {}));
/**
 * Helps build lemmy HTTP requests.
 */
class LemmyHttp {
    /**
     * Generates a new instance of LemmyHttp.
     * @param baseUrl the base url, without the vX version: https://lemmy.ml -> goes to https://lemmy.ml/api/vX
     * @param headers optional headers. Should contain `x-real-ip` and `x-forwarded-for` .
     */
    constructor(baseUrl, options) {
        _LemmyHttp_instances.add(this);
        _LemmyHttp_apiUrl.set(this, void 0);
        _LemmyHttp_headers.set(this, {});
        _LemmyHttp_pictrsUrl.set(this, void 0);
        _LemmyHttp_fetchFunction.set(this, cross_fetch_1.default);
        __classPrivateFieldSet(this, _LemmyHttp_apiUrl, `${baseUrl.replace(/\/+$/, "")}/api/${other_types_1.VERSION}`, "f");
        __classPrivateFieldSet(this, _LemmyHttp_pictrsUrl, `${baseUrl}/pictrs/image`, "f");
        if (options === null || options === void 0 ? void 0 : options.headers) {
            __classPrivateFieldSet(this, _LemmyHttp_headers, options.headers, "f");
        }
        if (options === null || options === void 0 ? void 0 : options.fetchFunction) {
            __classPrivateFieldSet(this, _LemmyHttp_fetchFunction, options.fetchFunction, "f");
        }
    }
    /**
     * Gets the site, and your user data.
     *
     * `HTTP.GET /site`
     */
    getSite() {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/site", {});
    }
    /**
     * Create your site.
     *
     * `HTTP.POST /site`
     */
    createSite(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/site", form);
    }
    /**
     * Edit your site.
     *
     * `HTTP.PUT /site`
     */
    editSite(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/site", form);
    }
    /**
     * Leave the Site admins.
     *
     * `HTTP.POST /user/leave_admin`
     */
    leaveAdmin() {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/leave_admin", {});
    }
    /**
     * Generate a TOTP / two-factor secret.
     *
     * Afterwards you need to call `/user/totp/update` with a valid token to enable it.
     *
     * `HTTP.POST /user/totp/generate`
     */
    generateTotpSecret() {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/totp/generate", {});
    }
    /**
     * Export a backup of your user settings, including your saved content,
     * followed communities, and blocks.
     *
     * `HTTP.GET /user/export_settings`
     */
    exportSettings() {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/export_settings", {});
    }
    /**
     * Import a backup of your user settings.
     *
     * `HTTP.POST /user/import_settings`
     */
    importSettings(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/import_settings", form);
    }
    /**
     * List login tokens for your user
     *
     * `HTTP.GET /user/list_logins`
     */
    listLogins() {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/list_logins", {});
    }
    /**
     * Returns an error message if your auth token is invalid
     *
     * `HTTP.GET /user/validate_auth`
     */
    validateAuth() {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/validate_auth", {});
    }
    /**
     * Enable / Disable TOTP / two-factor authentication.
     *
     * To enable, you need to first call `/user/totp/generate` and then pass a valid token to this.
     *
     * Disabling is only possible if 2FA was previously enabled. Again it is necessary to pass a valid token.
     *
     * `HTTP.POST /user/totp/update`
     */
    updateTotp(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/totp/update", form);
    }
    /**
     * Get the modlog.
     *
     * `HTTP.GET /modlog`
     */
    getModlog(form = {}) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/modlog", form);
    }
    /**
     * Search lemmy.
     *
     * `HTTP.GET /search`
     */
    search(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/search", form);
    }
    /**
     * Fetch a non-local / federated object.
     *
     * `HTTP.GET /resolve_object`
     */
    resolveObject(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/resolve_object", form);
    }
    /**
     * Create a new community.
     *
     * `HTTP.POST /community`
     */
    createCommunity(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community", form);
    }
    /**
     * Get / fetch a community.
     *
     * `HTTP.GET /community`
     */
    getCommunity(form = {}) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/community", form);
    }
    /**
     * Edit a community.
     *
     * `HTTP.PUT /community`
     */
    editCommunity(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/community", form);
    }
    /**
     * List communities, with various filters.
     *
     * `HTTP.GET /community/list`
     */
    listCommunities(form = {}) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/community/list", form);
    }
    /**
     * Follow / subscribe to a community.
     *
     * `HTTP.POST /community/follow`
     */
    followCommunity(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/follow", form);
    }
    /**
     * Block a community.
     *
     * `HTTP.POST /community/block`
     */
    blockCommunity(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/block", form);
    }
    /**
     * Delete a community.
     *
     * `HTTP.POST /community/delete`
     */
    deleteCommunity(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/delete", form);
    }
    /**
     * Hide a community from public / "All" view. Admins only.
     *
     * `HTTP.PUT /community/hide`
     */
    hideCommunity(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/community/hide", form);
    }
    /**
     * A moderator remove for a community.
     *
     * `HTTP.POST /community/remove`
     */
    removeCommunity(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/remove", form);
    }
    /**
     * Transfer your community to an existing moderator.
     *
     * `HTTP.POST /community/transfer`
     */
    transferCommunity(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/transfer", form);
    }
    /**
     * Ban a user from a community.
     *
     * `HTTP.POST /community/ban_user`
     */
    banFromCommunity(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/ban_user", form);
    }
    /**
     * Add a moderator to your community.
     *
     * `HTTP.POST /community/mod`
     */
    addModToCommunity(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/mod", form);
    }
    /**
     * Create a post.
     *
     * `HTTP.POST /post`
     */
    createPost(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post", form);
    }
    /**
     * Get / fetch a post.
     *
     * `HTTP.GET /post`
     */
    getPost(form = {}) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/post", form);
    }
    /**
     * Edit a post.
     *
     * `HTTP.PUT /post`
     */
    editPost(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/post", form);
    }
    /**
     * Delete a post.
     *
     * `HTTP.POST /post/delete`
     */
    deletePost(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/delete", form);
    }
    /**
     * A moderator remove for a post.
     *
     * `HTTP.POST /post/remove`
     */
    removePost(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/remove", form);
    }
    /**
     * Mark a post as read.
     *
     * `HTTP.POST /post/mark_as_read`
     */
    markPostAsRead(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/mark_as_read", form);
    }
    /**
     * A moderator can lock a post ( IE disable new comments ).
     *
     * `HTTP.POST /post/lock`
     */
    lockPost(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/lock", form);
    }
    /**
     * A moderator can feature a community post ( IE stick it to the top of a community ).
     *
     * `HTTP.POST /post/feature`
     */
    featurePost(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/feature", form);
    }
    /**
     * Get / fetch posts, with various filters.
     *
     * `HTTP.GET /post/list`
     */
    getPosts(form = {}) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/post/list", form);
    }
    /**
     * Like / vote on a post.
     *
     * `HTTP.POST /post/like`
     */
    likePost(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/like", form);
    }
    /**
     * Save a post.
     *
     * `HTTP.PUT /post/save`
     */
    savePost(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/post/save", form);
    }
    /**
     * Report a post.
     *
     * `HTTP.POST /post/report`
     */
    createPostReport(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/report", form);
    }
    /**
     * Resolve a post report. Only a mod can do this.
     *
     * `HTTP.PUT /post/report/resolve`
     */
    resolvePostReport(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/post/report/resolve", form);
    }
    /**
     * List post reports.
     *
     * `HTTP.GET /post/report/list`
     */
    listPostReports(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/post/report/list", form);
    }
    /**
     * Fetch metadata for any given site.
     *
     * `HTTP.GET /post/site_metadata`
     */
    getSiteMetadata(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/post/site_metadata", form);
    }
    /**
     * Create a comment.
     *
     * `HTTP.POST /comment`
     */
    createComment(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment", form);
    }
    /**
     * Edit a comment.
     *
     * `HTTP.PUT /comment`
     */
    editComment(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/comment", form);
    }
    /**
     * Delete a comment.
     *
     * `HTTP.POST /comment/delete`
     */
    deleteComment(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment/delete", form);
    }
    /**
     * A moderator remove for a comment.
     *
     * `HTTP.POST /comment/remove`
     */
    removeComment(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment/remove", form);
    }
    /**
     * Mark a comment as read.
     *
     * `HTTP.POST /comment/mark_as_read`
     */
    markCommentReplyAsRead(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment/mark_as_read", form);
    }
    /**
     * Like / vote on a comment.
     *
     * `HTTP.POST /comment/like`
     */
    likeComment(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment/like", form);
    }
    /**
     * Save a comment.
     *
     * `HTTP.PUT /comment/save`
     */
    saveComment(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/comment/save", form);
    }
    /**
     * Distinguishes a comment (speak as moderator)
     *
     * `HTTP.POST /comment/distinguish`
     */
    distinguishComment(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment/distinguish", form);
    }
    /**
     * Get / fetch comments.
     *
     * `HTTP.GET /comment/list`
     */
    getComments(form = {}) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/comment/list", form);
    }
    /**
     * Get / fetch comment.
     *
     * `HTTP.GET /comment`
     */
    getComment(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/comment", form);
    }
    /**
     * Report a comment.
     *
     * `HTTP.POST /comment/report`
     */
    createCommentReport(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment/report", form);
    }
    /**
     * Resolve a comment report. Only a mod can do this.
     *
     * `HTTP.PUT /comment/report/resolve`
     */
    resolveCommentReport(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/comment/report/resolve", form);
    }
    /**
     * List comment reports.
     *
     * `HTTP.GET /comment/report/list`
     */
    listCommentReports(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/comment/report/list", form);
    }
    /**
     * Get / fetch private messages.
     *
     * `HTTP.GET /private_message/list`
     */
    getPrivateMessages(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/private_message/list", form);
    }
    /**
     * Create a private message.
     *
     * `HTTP.POST /private_message`
     */
    createPrivateMessage(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/private_message", form);
    }
    /**
     * Edit a private message.
     *
     * `HTTP.PUT /private_message`
     */
    editPrivateMessage(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/private_message", form);
    }
    /**
     * Delete a private message.
     *
     * `HTTP.POST /private_message/delete`
     */
    deletePrivateMessage(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/private_message/delete", form);
    }
    /**
     * Mark a private message as read.
     *
     * `HTTP.POST /private_message/mark_as_read`
     */
    markPrivateMessageAsRead(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/private_message/mark_as_read", form);
    }
    /**
     * Create a report for a private message.
     *
     * `HTTP.POST /private_message/report`
     */
    createPrivateMessageReport(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/private_message/report", form);
    }
    /**
     * Resolve a report for a private message.
     *
     * `HTTP.PUT /private_message/report/resolve`
     */
    resolvePrivateMessageReport(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/private_message/report/resolve", form);
    }
    /**
     * List private message reports.
     *
     * `HTTP.GET /private_message/report/list`
     */
    listPrivateMessageReports(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/private_message/report/list", form);
    }
    /**
     * Register a new user.
     *
     * `HTTP.POST /user/register`
     */
    register(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/register", form);
    }
    /**
     * Log into lemmy.
     *
     * `HTTP.POST /user/login`
     */
    login(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/login", form);
    }
    logout() {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/logout", {});
    }
    /**
     * Get the details for a person.
     *
     * `HTTP.GET /user`
     */
    getPersonDetails(form = {}) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user", form);
    }
    /**
     * Get mentions for your user.
     *
     * `HTTP.GET /user/mention`
     */
    getPersonMentions(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/mention", form);
    }
    /**
     * Mark a person mention as read.
     *
     * `HTTP.POST /user/mention/mark_as_read`
     */
    markPersonMentionAsRead(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/mention/mark_as_read", form);
    }
    /**
     * Get comment replies.
     *
     * `HTTP.GET /user/replies`
     */
    getReplies(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/replies", form);
    }
    /**
     * Ban a person from your site.
     *
     * `HTTP.POST /user/ban`
     */
    banPerson(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/ban", form);
    }
    /**
     * Get a list of banned users
     *
     * `HTTP.GET /user/banned`
     */
    getBannedPersons() {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/banned", {});
    }
    /**
     * Block a person.
     *
     * `HTTP.POST /user/block`
     */
    blockPerson(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/block", form);
    }
    /**
     * Fetch a Captcha.
     *
     * `HTTP.GET /user/get_captcha`
     */
    getCaptcha() {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/get_captcha", {});
    }
    /**
     * Delete your account.
     *
     * `HTTP.POST /user/delete_account`
     */
    deleteAccount(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/delete_account", form);
    }
    /**
     * Reset your password.
     *
     * `HTTP.POST /user/password_reset`
     */
    passwordReset(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/password_reset", form);
    }
    /**
     * Change your password from an email / token based reset.
     *
     * `HTTP.POST /user/password_change`
     */
    passwordChangeAfterReset(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/password_change", form);
    }
    /**
     * Mark all replies as read.
     *
     * `HTTP.POST /user/mark_all_as_read`
     */
    markAllAsRead() {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/mark_all_as_read", {});
    }
    /**
     * Save your user settings.
     *
     * `HTTP.PUT /user/save_user_settings`
     */
    saveUserSettings(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/user/save_user_settings", form);
    }
    /**
     * Change your user password.
     *
     * `HTTP.PUT /user/change_password`
     */
    changePassword(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/user/change_password", form);
    }
    /**
     * Get counts for your reports
     *
     * `HTTP.GET /user/report_count`
     */
    getReportCount(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/report_count", form);
    }
    /**
     * Get your unread counts
     *
     * `HTTP.GET /user/unread_count`
     */
    getUnreadCount() {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/unread_count", {});
    }
    /**
     * Verify your email
     *
     * `HTTP.POST /user/verify_email`
     */
    verifyEmail(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/verify_email", form);
    }
    /**
     * Add an admin to your site.
     *
     * `HTTP.POST /admin/add`
     */
    addAdmin(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/admin/add", form);
    }
    /**
     * Get the unread registration applications count.
     *
     * `HTTP.GET /admin/registration_application/count`
     */
    getUnreadRegistrationApplicationCount() {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/admin/registration_application/count", {});
    }
    /**
     * List the registration applications.
     *
     * `HTTP.GET /admin/registration_application/list`
     */
    listRegistrationApplications(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/admin/registration_application/list", form);
    }
    /**
     * Approve a registration application
     *
     * `HTTP.PUT /admin/registration_application/approve`
     */
    approveRegistrationApplication(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/admin/registration_application/approve", form);
    }
    /**
     * Purge / Delete a person from the database.
     *
     * `HTTP.POST /admin/purge/person`
     */
    purgePerson(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/admin/purge/person", form);
    }
    /**
     * Purge / Delete a community from the database.
     *
     * `HTTP.POST /admin/purge/community`
     */
    purgeCommunity(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/admin/purge/community", form);
    }
    /**
     * Purge / Delete a post from the database.
     *
     * `HTTP.POST /admin/purge/post`
     */
    purgePost(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/admin/purge/post", form);
    }
    /**
     * Purge / Delete a comment from the database.
     *
     * `HTTP.POST /admin/purge/comment`
     */
    purgeComment(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/admin/purge/comment", form);
    }
    /**
     * Create a new custom emoji
     *
     * `HTTP.POST /custom_emoji`
     */
    createCustomEmoji(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/custom_emoji", form);
    }
    /**
     * Edit an existing custom emoji
     *
     * `HTTP.PUT /custom_emoji`
     */
    editCustomEmoji(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/custom_emoji", form);
    }
    /**
     * Delete a custom emoji
     *
     * `HTTP.Post /custom_emoji/delete`
     */
    deleteCustomEmoji(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/custom_emoji/delete", form);
    }
    /**
     * Fetch federated instances.
     *
     * `HTTP.Get /federated_instances`
     */
    getFederatedInstances() {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/federated_instances", {});
    }
    /**
     * Block an instance.
     *
     * `HTTP.Post /site/block`
     */
    blockInstance(form) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/site/block", form);
    }
    /**
     * Upload an image to the server.
     */
    uploadImage({ image }) {
        return __awaiter(this, void 0, void 0, function* () {
            const formData = createFormData(image);
            let url = undefined;
            let delete_url = undefined;
            const response = yield __classPrivateFieldGet(this, _LemmyHttp_fetchFunction, "f").call(this, __classPrivateFieldGet(this, _LemmyHttp_pictrsUrl, "f"), {
                method: HttpType.Post,
                body: formData,
                headers: __classPrivateFieldGet(this, _LemmyHttp_headers, "f"),
            });
            if (response.status === 413) {
                return { msg: "too_large" };
            }
            const responseJson = yield response.json();
            if (responseJson.msg === "ok") {
                const { file: hash, delete_token: deleteToken } = responseJson.files[0];
                delete_url = `${__classPrivateFieldGet(this, _LemmyHttp_pictrsUrl, "f")}/delete/${deleteToken}/${hash}`;
                url = `${__classPrivateFieldGet(this, _LemmyHttp_pictrsUrl, "f")}/${hash}`;
            }
            return Object.assign(Object.assign({}, responseJson), { url,
                delete_url });
        });
    }
    /**
     * Delete a pictrs image
     */
    deleteImage({ token, filename }) {
        return __awaiter(this, void 0, void 0, function* () {
            const deleteUrl = `${__classPrivateFieldGet(this, _LemmyHttp_pictrsUrl, "f")}/delete/${token}/${filename}`;
            const response = yield __classPrivateFieldGet(this, _LemmyHttp_fetchFunction, "f").call(this, deleteUrl, {
                method: HttpType.Get,
                headers: __classPrivateFieldGet(this, _LemmyHttp_headers, "f"),
            });
            return (yield response.status) == 204;
        });
    }
    /**
     * Set the headers (can be used to set the auth header)
     */
    setHeaders(headers) {
        __classPrivateFieldSet(this, _LemmyHttp_headers, headers, "f");
    }
}
exports.LemmyHttp = LemmyHttp;
_LemmyHttp_apiUrl = new WeakMap(), _LemmyHttp_headers = new WeakMap(), _LemmyHttp_pictrsUrl = new WeakMap(), _LemmyHttp_fetchFunction = new WeakMap(), _LemmyHttp_instances = new WeakSet(), _LemmyHttp_buildFullUrl = function _LemmyHttp_buildFullUrl(endpoint) {
    return `${__classPrivateFieldGet(this, _LemmyHttp_apiUrl, "f")}${endpoint}`;
}, _LemmyHttp_wrapper = function _LemmyHttp_wrapper(type_, endpoint, form) {
    var _a;
    return __awaiter(this, void 0, void 0, function* () {
        let response;
        if (type_ === HttpType.Get) {
            const getUrl = `${__classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_buildFullUrl).call(this, endpoint)}?${encodeGetParams(form)}`;
            response = yield __classPrivateFieldGet(this, _LemmyHttp_fetchFunction, "f").call(this, getUrl, {
                method: HttpType.Get,
                headers: __classPrivateFieldGet(this, _LemmyHttp_headers, "f"),
            });
        }
        else {
            response = yield __classPrivateFieldGet(this, _LemmyHttp_fetchFunction, "f").call(this, __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_buildFullUrl).call(this, endpoint), {
                method: type_,
                headers: Object.assign({ "Content-Type": "application/json" }, __classPrivateFieldGet(this, _LemmyHttp_headers, "f")),
                body: JSON.stringify(form),
            });
        }
        let json = undefined;
        try {
            json = yield response.json();
        }
        catch (error) {
            throw new Error(response.statusText);
        }
        if (!response.ok) {
            throw new Error((_a = json["error"]) !== null && _a !== void 0 ? _a : response.statusText);
        }
        else {
            return json;
        }
    });
};
function encodeGetParams(p) {
    return Object.entries(p)
        .filter(kv => !!kv[1])
        .map(kv => kv.map(encodeURIComponent).join("="))
        .join("&");
}
function createFormData(image) {
    let formData = new form_data_1.default();
    if (image.constructor.name === "File") {
        formData.append("images[]", image);
    }
    else {
        // The filename doesn't affect the file type or file name that ends up in pictrs
        formData.append("images[]", image, { filename: "image.jpg" });
    }
    return formData;
}
