'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@capacitor/core');

/**
 * Primary biometric method
 */
exports.BiometricMethod = void 0;
(function (BiometricMethod) {
    /**
     * No biometry is available
     */
    BiometricMethod[BiometricMethod["none"] = 0] = "none";
    /**
     * iOS Touch ID is available
     */
    BiometricMethod[BiometricMethod["touchId"] = 1] = "touchId";
    /**
     * iOS Face ID is available
     */
    BiometricMethod[BiometricMethod["faceId"] = 2] = "faceId";
    /**
     * Android fingerprint authentication is available
     */
    BiometricMethod[BiometricMethod["fingerprintAuthentication"] = 3] = "fingerprintAuthentication";
    /**
     * Android face authentication is available
     */
    BiometricMethod[BiometricMethod["faceAuthentication"] = 4] = "faceAuthentication";
    /**
     * Android iris authentication is available
     */
    BiometricMethod[BiometricMethod["irisAuthentication"] = 5] = "irisAuthentication";
})(exports.BiometricMethod || (exports.BiometricMethod = {}));

const BiometricLock = core.registerPlugin('BiometricLock', {
    web: () => Promise.resolve().then(function () { return web; }).then(m => new m.BiometricLockWeb()),
});

class BiometricLockWeb extends core.WebPlugin {
    async configure() {
        throw this.unimplemented('Not implemented on web.');
    }
    async getConfiguration() {
        throw this.unimplemented('Not implemented on web.');
    }
    async getBiometricMethod() {
        throw this.unimplemented('Not implemented on web.');
    }
}

var web = /*#__PURE__*/Object.freeze({
    __proto__: null,
    BiometricLockWeb: BiometricLockWeb
});

exports.BiometricLock = BiometricLock;
//# sourceMappingURL=plugin.cjs.js.map
