/* eslint-disable @typescript-eslint/no-unused-vars */
import { WebPlugin } from '@capacitor/core';
import { REFUND_REQUEST_STATUS } from '@revenuecat/purchases-typescript-internal-esm';
export class PurchasesWeb extends WebPlugin {
    constructor() {
        super(...arguments);
        this.shouldMockWebResults = false;
        this.webNotSupportedErrorMessage = 'Web not supported in this plugin.';
        // Mock helpers
        this.mockEmptyCustomerInfo = {
            entitlements: { all: {}, active: {} },
            activeSubscriptions: [],
            allPurchasedProductIdentifiers: [],
            latestExpirationDate: null,
            firstSeen: '2023-08-31T15:11:21.445Z',
            originalAppUserId: 'mock-web-user-id',
            requestDate: '2023-08-31T15:11:21.445Z',
            allExpirationDates: {},
            allPurchaseDates: {},
            originalApplicationVersion: null,
            originalPurchaseDate: null,
            managementURL: null,
            nonSubscriptionTransactions: [],
        };
    }
    configure(_configuration) {
        return this.mockNonReturningFunctionIfEnabled('configure');
    }
    setMockWebResults(options) {
        this.shouldMockWebResults = options.shouldMockWebResults;
        return Promise.resolve();
    }
    setFinishTransactions(_finishTransactions) {
        return this.mockNonReturningFunctionIfEnabled('setFinishTransactions');
    }
    setSimulatesAskToBuyInSandbox(_simulatesAskToBuyInSandbox) {
        return this.mockNonReturningFunctionIfEnabled('setSimulatesAskToBuyInSandbox');
    }
    addCustomerInfoUpdateListener(_customerInfoUpdateListener) {
        return this.mockReturningFunctionIfEnabled('addCustomerInfoUpdateListener', 'mock-callback-id');
    }
    removeCustomerInfoUpdateListener(_listenerToRemove) {
        return this.mockReturningFunctionIfEnabled('removeCustomerInfoUpdateListener', { wasRemoved: false });
    }
    addShouldPurchasePromoProductListener(_shouldPurchasePromoProductListener) {
        return this.mockReturningFunctionIfEnabled('addShouldPurchasePromoProductListener', 'mock-callback-id');
    }
    removeShouldPurchasePromoProductListener(_listenerToRemove) {
        return this.mockReturningFunctionIfEnabled('removeShouldPurchasePromoProductListener', { wasRemoved: false });
    }
    getOfferings() {
        const mockOfferings = {
            all: {},
            current: null,
        };
        return this.mockReturningFunctionIfEnabled('getOfferings', mockOfferings);
    }
    getProducts(_options) {
        const mockProducts = { products: [] };
        return this.mockReturningFunctionIfEnabled('getProducts', mockProducts);
    }
    purchaseStoreProduct(_options) {
        const mockPurchaseResult = {
            productIdentifier: _options.product.identifier,
            customerInfo: this.mockEmptyCustomerInfo,
        };
        return this.mockReturningFunctionIfEnabled('purchaseStoreProduct', mockPurchaseResult);
    }
    purchaseDiscountedProduct(_options) {
        const mockPurchaseResult = {
            productIdentifier: _options.product.identifier,
            customerInfo: this.mockEmptyCustomerInfo,
        };
        return this.mockReturningFunctionIfEnabled('purchaseDiscountedProduct', mockPurchaseResult);
    }
    purchasePackage(_options) {
        const mockPurchaseResult = {
            productIdentifier: _options.aPackage.product.identifier,
            customerInfo: this.mockEmptyCustomerInfo,
        };
        return this.mockReturningFunctionIfEnabled('purchasePackage', mockPurchaseResult);
    }
    purchaseSubscriptionOption(_options) {
        const mockPurchaseResult = {
            productIdentifier: _options.subscriptionOption.productId,
            customerInfo: this.mockEmptyCustomerInfo,
        };
        return this.mockReturningFunctionIfEnabled('purchaseSubscriptionOption', mockPurchaseResult);
    }
    purchaseDiscountedPackage(_options) {
        const mockPurchaseResult = {
            productIdentifier: _options.aPackage.product.identifier,
            customerInfo: this.mockEmptyCustomerInfo,
        };
        return this.mockReturningFunctionIfEnabled('purchaseDiscountedPackage', mockPurchaseResult);
    }
    restorePurchases() {
        const mockResponse = { customerInfo: this.mockEmptyCustomerInfo };
        return this.mockReturningFunctionIfEnabled('restorePurchases', mockResponse);
    }
    getAppUserID() {
        return this.mockReturningFunctionIfEnabled('getAppUserID', {
            appUserID: 'test-web-user-id',
        });
    }
    logIn(_appUserID) {
        const mockLogInResult = {
            customerInfo: this.mockEmptyCustomerInfo,
            created: false,
        };
        return this.mockReturningFunctionIfEnabled('logIn', mockLogInResult);
    }
    logOut() {
        const mockResponse = { customerInfo: this.mockEmptyCustomerInfo };
        return this.mockReturningFunctionIfEnabled('logOut', mockResponse);
    }
    setLogLevel(_level) {
        return this.mockNonReturningFunctionIfEnabled('setLogLevel');
    }
    setLogHandler(_logHandler) {
        return this.mockNonReturningFunctionIfEnabled('setLogHandler');
    }
    getCustomerInfo() {
        const mockResponse = { customerInfo: this.mockEmptyCustomerInfo };
        return this.mockReturningFunctionIfEnabled('getCustomerInfo', mockResponse);
    }
    syncPurchases() {
        return this.mockNonReturningFunctionIfEnabled('syncPurchases');
    }
    syncObserverModeAmazonPurchase(_options) {
        return this.mockNonReturningFunctionIfEnabled('syncObserverModeAmazonPurchase');
    }
    enableAdServicesAttributionTokenCollection() {
        return this.mockNonReturningFunctionIfEnabled('enableAdServicesAttributionTokenCollection');
    }
    isAnonymous() {
        const mockResponse = { isAnonymous: false };
        return this.mockReturningFunctionIfEnabled('isAnonymous', mockResponse);
    }
    checkTrialOrIntroductoryPriceEligibility(_productIdentifiers) {
        return this.mockReturningFunctionIfEnabled('checkTrialOrIntroductoryPriceEligibility', {});
    }
    getPromotionalOffer(_options) {
        return this.mockReturningFunctionIfEnabled('getPromotionalOffer', undefined);
    }
    invalidateCustomerInfoCache() {
        return this.mockNonReturningFunctionIfEnabled('invalidateCustomerInfoCache');
    }
    presentCodeRedemptionSheet() {
        return this.mockNonReturningFunctionIfEnabled('presentCodeRedemptionSheet');
    }
    setAttributes(_attributes) {
        return this.mockNonReturningFunctionIfEnabled('setAttributes');
    }
    setEmail(_email) {
        return this.mockNonReturningFunctionIfEnabled('setEmail');
    }
    setPhoneNumber(_phoneNumber) {
        return this.mockNonReturningFunctionIfEnabled('setPhoneNumber');
    }
    setDisplayName(_displayName) {
        return this.mockNonReturningFunctionIfEnabled('setDisplayName');
    }
    setPushToken(_pushToken) {
        return this.mockNonReturningFunctionIfEnabled('setPushToken');
    }
    setProxyURL(_url) {
        return this.mockNonReturningFunctionIfEnabled('setProxyURL');
    }
    collectDeviceIdentifiers() {
        return this.mockNonReturningFunctionIfEnabled('collectDeviceIdentifiers');
    }
    setAdjustID(_adjustID) {
        return this.mockNonReturningFunctionIfEnabled('setAdjustID');
    }
    setAppsflyerID(_appsflyerID) {
        return this.mockNonReturningFunctionIfEnabled('setAppsflyerID');
    }
    setFBAnonymousID(_fbAnonymousID) {
        return this.mockNonReturningFunctionIfEnabled('setFBAnonymousID');
    }
    setMparticleID(_mparticleID) {
        return this.mockNonReturningFunctionIfEnabled('setMparticleID');
    }
    setCleverTapID(_cleverTapID) {
        return this.mockNonReturningFunctionIfEnabled('setCleverTapID');
    }
    setMixpanelDistinctID(_mixpanelDistinctID) {
        return this.mockNonReturningFunctionIfEnabled('setMixpanelDistinctID');
    }
    setFirebaseAppInstanceID(_firebaseAppInstanceID) {
        return this.mockNonReturningFunctionIfEnabled('setFirebaseAppInstanceID');
    }
    setOnesignalID(_onesignalID) {
        return this.mockNonReturningFunctionIfEnabled('setOnesignalID');
    }
    setAirshipChannelID(_airshipChannelID) {
        return this.mockNonReturningFunctionIfEnabled('setAirshipChannelID');
    }
    setMediaSource(_mediaSource) {
        return this.mockNonReturningFunctionIfEnabled('setMediaSource');
    }
    setCampaign(_campaign) {
        return this.mockNonReturningFunctionIfEnabled('setCampaign');
    }
    setAdGroup(_adGroup) {
        return this.mockNonReturningFunctionIfEnabled('setAdGroup');
    }
    setAd(_ad) {
        return this.mockNonReturningFunctionIfEnabled('setAd');
    }
    setKeyword(_keyword) {
        return this.mockNonReturningFunctionIfEnabled('setKeyword');
    }
    setCreative(_creative) {
        return this.mockNonReturningFunctionIfEnabled('setCreative');
    }
    canMakePayments(_features) {
        return this.mockReturningFunctionIfEnabled('canMakePayments', {
            canMakePayments: true,
        });
    }
    beginRefundRequestForActiveEntitlement() {
        const mockResult = {
            refundRequestStatus: REFUND_REQUEST_STATUS.USER_CANCELLED,
        };
        return this.mockReturningFunctionIfEnabled('beginRefundRequestForActiveEntitlement', mockResult);
    }
    beginRefundRequestForEntitlement(_entitlementInfo) {
        const mockResult = {
            refundRequestStatus: REFUND_REQUEST_STATUS.USER_CANCELLED,
        };
        return this.mockReturningFunctionIfEnabled('beginRefundRequestForEntitlement', mockResult);
    }
    beginRefundRequestForProduct(_storeProduct) {
        const mockResult = {
            refundRequestStatus: REFUND_REQUEST_STATUS.USER_CANCELLED,
        };
        return this.mockReturningFunctionIfEnabled('beginRefundRequestForProduct', mockResult);
    }
    showInAppMessages(_options) {
        return this.mockNonReturningFunctionIfEnabled('showInAppMessages');
    }
    isConfigured() {
        const mockResult = { isConfigured: true };
        return this.mockReturningFunctionIfEnabled('isConfigured', mockResult);
    }
    mockNonReturningFunctionIfEnabled(functionName) {
        if (!this.shouldMockWebResults) {
            return Promise.reject(this.webNotSupportedErrorMessage);
        }
        console.log(`${functionName} called on web with mocking enabled. No-op`);
        return Promise.resolve();
    }
    mockReturningFunctionIfEnabled(functionName, returnValue) {
        if (!this.shouldMockWebResults) {
            return Promise.reject(this.webNotSupportedErrorMessage);
        }
        console.log(`${functionName} called on web with mocking enabled. Returning mocked value`);
        return Promise.resolve(returnValue);
    }
}
//# sourceMappingURL=web.js.map