import { WebPlugin } from '@capacitor/core';
import type { BILLING_FEATURE, CustomerInfo, CustomerInfoUpdateListener, IN_APP_MESSAGE_TYPE, IntroEligibility, LOG_LEVEL, LogHandler, LogInResult, MakePurchaseResult, PurchasesConfiguration, PurchasesEntitlementInfo, PurchasesOfferings, PurchasesPromotionalOffer, PurchasesStoreProduct, ShouldPurchasePromoProductListener } from '@revenuecat/purchases-typescript-internal-esm';
import { REFUND_REQUEST_STATUS } from '@revenuecat/purchases-typescript-internal-esm';
import type { GetProductOptions, GetPromotionalOfferOptions, PurchaseDiscountedPackageOptions, PurchaseDiscountedProductOptions, PurchasePackageOptions, PurchasesPlugin, PurchaseStoreProductOptions, PurchaseSubscriptionOptionOptions, SyncObserverModeAmazonPurchaseOptions } from './definitions';
export declare class PurchasesWeb extends WebPlugin implements PurchasesPlugin {
    private shouldMockWebResults;
    private webNotSupportedErrorMessage;
    configure(_configuration: PurchasesConfiguration): Promise<void>;
    setMockWebResults(options: {
        shouldMockWebResults: boolean;
    }): Promise<void>;
    setFinishTransactions(_finishTransactions: {
        finishTransactions: boolean;
    }): Promise<void>;
    setSimulatesAskToBuyInSandbox(_simulatesAskToBuyInSandbox: {
        simulatesAskToBuyInSandbox: boolean;
    }): Promise<void>;
    addCustomerInfoUpdateListener(_customerInfoUpdateListener: CustomerInfoUpdateListener): Promise<string>;
    removeCustomerInfoUpdateListener(_listenerToRemove: string): Promise<{
        wasRemoved: boolean;
    }>;
    addShouldPurchasePromoProductListener(_shouldPurchasePromoProductListener: ShouldPurchasePromoProductListener): Promise<string>;
    removeShouldPurchasePromoProductListener(_listenerToRemove: string): Promise<{
        wasRemoved: boolean;
    }>;
    getOfferings(): Promise<PurchasesOfferings>;
    getProducts(_options: GetProductOptions): Promise<{
        products: PurchasesStoreProduct[];
    }>;
    purchaseStoreProduct(_options: PurchaseStoreProductOptions): Promise<MakePurchaseResult>;
    purchaseDiscountedProduct(_options: PurchaseDiscountedProductOptions): Promise<MakePurchaseResult>;
    purchasePackage(_options: PurchasePackageOptions): Promise<MakePurchaseResult>;
    purchaseSubscriptionOption(_options: PurchaseSubscriptionOptionOptions): Promise<MakePurchaseResult>;
    purchaseDiscountedPackage(_options: PurchaseDiscountedPackageOptions): Promise<MakePurchaseResult>;
    restorePurchases(): Promise<{
        customerInfo: CustomerInfo;
    }>;
    getAppUserID(): Promise<{
        appUserID: string;
    }>;
    logIn(_appUserID: {
        appUserID: string;
    }): Promise<LogInResult>;
    logOut(): Promise<{
        customerInfo: CustomerInfo;
    }>;
    setLogLevel(_level: {
        level: LOG_LEVEL;
    }): Promise<void>;
    setLogHandler(_logHandler: LogHandler): Promise<void>;
    getCustomerInfo(): Promise<{
        customerInfo: CustomerInfo;
    }>;
    syncPurchases(): Promise<void>;
    syncObserverModeAmazonPurchase(_options: SyncObserverModeAmazonPurchaseOptions): Promise<void>;
    enableAdServicesAttributionTokenCollection(): Promise<void>;
    isAnonymous(): Promise<{
        isAnonymous: boolean;
    }>;
    checkTrialOrIntroductoryPriceEligibility(_productIdentifiers: {
        productIdentifiers: string[];
    }): Promise<{
        [productId: string]: IntroEligibility;
    }>;
    getPromotionalOffer(_options: GetPromotionalOfferOptions): Promise<PurchasesPromotionalOffer | undefined>;
    invalidateCustomerInfoCache(): Promise<void>;
    presentCodeRedemptionSheet(): Promise<void>;
    setAttributes(_attributes: {
        [key: string]: string | null;
    }): Promise<void>;
    setEmail(_email: {
        email: string | null;
    }): Promise<void>;
    setPhoneNumber(_phoneNumber: {
        phoneNumber: string | null;
    }): Promise<void>;
    setDisplayName(_displayName: {
        displayName: string | null;
    }): Promise<void>;
    setPushToken(_pushToken: {
        pushToken: string | null;
    }): Promise<void>;
    setProxyURL(_url: {
        url: string;
    }): Promise<void>;
    collectDeviceIdentifiers(): Promise<void>;
    setAdjustID(_adjustID: {
        adjustID: string | null;
    }): Promise<void>;
    setAppsflyerID(_appsflyerID: {
        appsflyerID: string | null;
    }): Promise<void>;
    setFBAnonymousID(_fbAnonymousID: {
        fbAnonymousID: string | null;
    }): Promise<void>;
    setMparticleID(_mparticleID: {
        mparticleID: string | null;
    }): Promise<void>;
    setCleverTapID(_cleverTapID: {
        cleverTapID: string | null;
    }): Promise<void>;
    setMixpanelDistinctID(_mixpanelDistinctID: {
        mixpanelDistinctID: string | null;
    }): Promise<void>;
    setFirebaseAppInstanceID(_firebaseAppInstanceID: {
        firebaseAppInstanceID: string | null;
    }): Promise<void>;
    setOnesignalID(_onesignalID: {
        onesignalID: string | null;
    }): Promise<void>;
    setAirshipChannelID(_airshipChannelID: {
        airshipChannelID: string | null;
    }): Promise<void>;
    setMediaSource(_mediaSource: {
        mediaSource: string | null;
    }): Promise<void>;
    setCampaign(_campaign: {
        campaign: string | null;
    }): Promise<void>;
    setAdGroup(_adGroup: {
        adGroup: string | null;
    }): Promise<void>;
    setAd(_ad: {
        ad: string | null;
    }): Promise<void>;
    setKeyword(_keyword: {
        keyword: string | null;
    }): Promise<void>;
    setCreative(_creative: {
        creative: string | null;
    }): Promise<void>;
    canMakePayments(_features?: {
        features?: BILLING_FEATURE[];
    }): Promise<{
        canMakePayments: boolean;
    }>;
    beginRefundRequestForActiveEntitlement(): Promise<{
        refundRequestStatus: REFUND_REQUEST_STATUS;
    }>;
    beginRefundRequestForEntitlement(_entitlementInfo: {
        entitlementInfo: PurchasesEntitlementInfo;
    }): Promise<{
        refundRequestStatus: REFUND_REQUEST_STATUS;
    }>;
    beginRefundRequestForProduct(_storeProduct: {
        storeProduct: PurchasesStoreProduct;
    }): Promise<{
        refundRequestStatus: REFUND_REQUEST_STATUS;
    }>;
    showInAppMessages(_options?: {
        messageTypes?: IN_APP_MESSAGE_TYPE[];
    }): Promise<void>;
    isConfigured(): Promise<{
        isConfigured: boolean;
    }>;
    private mockEmptyCustomerInfo;
    private mockNonReturningFunctionIfEnabled;
    private mockReturningFunctionIfEnabled;
}
