"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const url_1 = __importDefault(require("url"));
const dns_1 = __importDefault(require("dns"));
const file_1 = __importDefault(require("./file"));
const logger_1 = __importDefault(require("./logger"));
const isUrl = (val) => {
    const parsedUrl = url_1.default.parse(val);
    return ['http:', 'https:'].includes(parsedUrl.protocol);
};
// TODO: Find a better way to check url existence
const isUrlExists = (source) => {
    return new Promise((resolve, reject) => {
        try {
            dns_1.default.resolve(url_1.default.parse(source).hostname, (err) => {
                if (err) {
                    return resolve(false);
                }
                return resolve(true);
            });
        }
        catch (e) {
            reject(e);
        }
    });
};
const getAddress = (source, options) => __awaiter(void 0, void 0, void 0, function* () {
    const logger = (0, logger_1.default)(getAddress.name, options);
    if (isUrl(source)) {
        if (!(yield isUrlExists(source))) {
            throw Error(`Cannot resolve ${source}. Please check your internet connection`);
        }
        logger.log('Providing url source as navigation address');
        return source;
    }
    if (file_1.default.isHtmlFile(source)) {
        logger.log('Providing html file path as navigation address');
        return file_1.default.getFileUrlOfPath(source);
    }
    return source;
});
const getShellHtml = (source, options) => __awaiter(void 0, void 0, void 0, function* () {
    const logger = (0, logger_1.default)(getShellHtml.name, options);
    const useShell = (isSourceUrl = false) => __awaiter(void 0, void 0, void 0, function* () {
        logger.log('Providing shell html as page content');
        return file_1.default.getHtmlShell(source, options, isSourceUrl);
    });
    if (isUrl(source)) {
        if (!(yield isUrlExists(source))) {
            throw Error(`Cannot resolve ${source}. Please check your internet connection`);
        }
        logger.log('Generating shell html with provided image url');
        return useShell(true);
    }
    if (!(yield file_1.default.isPathAccessible(source, file_1.default.READ_ACCESS))) {
        throw Error(`Cannot find path ${source}. Please check if file exists`);
    }
    logger.log('Generating shell html with provided image source');
    return useShell();
});
exports.default = { isUrl, isUrlExists, getAddress, getShellHtml };
//# sourceMappingURL=url.js.map