"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const puppeteer_core_1 = __importDefault(require("puppeteer-core"));
const progress_1 = __importDefault(require("progress"));
const logger_1 = __importDefault(require("./logger"));
let browserFetcher;
// Override current environment proxy settings with npm configuration, if any.
const NPM_HTTPS_PROXY = process.env.npm_config_https_proxy || process.env.npm_config_proxy;
const NPM_HTTP_PROXY = process.env.npm_config_http_proxy || process.env.npm_config_proxy;
const NPM_NO_PROXY = process.env.npm_config_no_proxy;
if (NPM_HTTPS_PROXY)
    process.env.HTTPS_PROXY = NPM_HTTPS_PROXY;
if (NPM_HTTP_PROXY)
    process.env.HTTP_PROXY = NPM_HTTP_PROXY;
if (NPM_NO_PROXY)
    process.env.NO_PROXY = NPM_NO_PROXY;
const getBrowserFetcher = () => {
    const downloadHost = process.env.PUPPETEER_DOWNLOAD_HOST ||
        process.env.npm_config_puppeteer_download_host ||
        process.env.npm_package_config_puppeteer_download_host;
    if (browserFetcher) {
        return browserFetcher;
    }
    // The next line uses a workaround for this issue: https://github.com/puppeteer/puppeteer/issues/7100
    browserFetcher = puppeteer_core_1.default.createBrowserFetcher({ host: downloadHost });
    return browserFetcher;
};
const getPreferredBrowserRevisionInfo = () => {
    const revision = process.env.PUPPETEER_CHROMIUM_REVISION ||
        process.env.npm_config_puppeteer_chromium_revision ||
        process.env.npm_package_config_puppeteer_chromium_revision ||
        require('puppeteer-core/lib/cjs/puppeteer/revisions.js').PUPPETEER_REVISIONS
            .chromium;
    return getBrowserFetcher().revisionInfo(revision);
};
const { revision } = getPreferredBrowserRevisionInfo();
const revisionInfo = getBrowserFetcher().revisionInfo(revision);
const logger = (0, logger_1.default)('installer');
const toMegabytes = (bytes) => {
    const mb = bytes / 1024 / 1024;
    return `${Math.round(mb * 10) / 10} Mb`;
};
const cleanUpOldRevisions = (revisions) => {
    const localRevisions = revisions.filter((rev) => revision !== rev);
    // Remove previous chromium revisions.
    const cleanupOldVersions = localRevisions.map((rev) => getBrowserFetcher().remove(rev));
    return Promise.all([...cleanupOldVersions]);
};
let progressBar;
let lastDownloadedBytes = 0;
const onProgress = (downloadedBytes, totalBytes) => {
    if (!progressBar) {
        progressBar = new progress_1.default(`Downloading Chromium r${revision} - ${toMegabytes(totalBytes)} [:bar] :percent :etas `, {
            complete: '=',
            incomplete: ' ',
            width: 20,
            total: totalBytes,
        });
    }
    const delta = downloadedBytes - lastDownloadedBytes;
    lastDownloadedBytes = downloadedBytes;
    progressBar.tick(delta);
};
const installPreferredBrowserRevision = () => __awaiter(void 0, void 0, void 0, function* () {
    logger.warn(`Chromium is not found in module folder, gonna have to download r${revision} for you once`);
    const installedRevision = yield getBrowserFetcher().download(revision, onProgress);
    logger.log(`Chromium downloaded to ${revisionInfo.folderPath}`);
    yield getBrowserFetcher().localRevisions().then(cleanUpOldRevisions);
    return installedRevision;
});
exports.default = {
    getBrowserFetcher,
    installPreferredBrowserRevision,
    getPreferredBrowserRevisionInfo,
};
//# sourceMappingURL=installer.js.map