/*!
 * (C) Ionic http://ionicframework.com - MIT License
 */
import { expect } from "@playwright/test";
import { configs, test } from "../../../../utils/test/playwright/index";
import { openPopover } from "../test.utils";
configs({ modes: ['md'], directions: ['ltr'] }).forEach(({ title, config }) => {
  test.describe(title('popover: trigger'), async () => {
    test.beforeEach(async ({ page }) => {
      await page.goto('/src/components/popover/test/trigger', config);
    });
    test('should open popover by left clicking on trigger', async ({ page }) => {
      await openPopover(page, 'left-click-trigger');
      await checkPopover(page, '.left-click-popover');
    });
    test('should open popover by right clicking on trigger', async ({ page }) => {
      const ionPopoverDidPresent = await page.spyOnEvent('ionPopoverDidPresent');
      await page.click('#right-click-trigger', { button: 'right' });
      await ionPopoverDidPresent.next();
      await checkPopover(page, '.right-click-popover');
    });
    test('should open popover by hovering over trigger', async ({ page }) => {
      const ionPopoverDidPresent = await page.spyOnEvent('ionPopoverDidPresent');
      const button = page.locator('#hover-trigger');
      await button.hover();
      await ionPopoverDidPresent.next();
      await checkPopover(page, '.hover-popover');
    });
    test('should still open popover when it has been removed and re-added to DOM', async ({ page }) => {
      const button = page.locator('#left-click-trigger');
      const popover = page.locator('.left-click-popover');
      await popover.evaluate((popover) => {
        var _a;
        popover.remove();
        (_a = document.querySelector('ion-button')) === null || _a === void 0 ? void 0 : _a.insertAdjacentElement('afterend', popover);
      });
      await page.waitForChanges();
      await button.click();
      await expect(popover).toBeVisible();
    });
  });
});
const checkPopover = async (page, popoverSelector) => {
  const popover = page.locator(popoverSelector);
  await expect(popover).toBeVisible();
};
