/*!
 * (C) Ionic http://ionicframework.com - MIT License
 */
import { expect } from "@playwright/test";
import { configs, test } from "../../../../utils/test/playwright/index";
configs({ directions: ['ltr'] }).forEach(({ title, screenshot, config }) => {
  test.describe(title('card: font scaling'), () => {
    test('should scale text on larger font sizes', async ({ page }) => {
      await page.setContent(`
        <style>
          html {
            font-size: 36px;
          }
        </style>
        <ion-card>
          <ion-card-header>
            <ion-card-title>Card Title</ion-card-title>
            <ion-card-subtitle>Card Subtitle</ion-card-subtitle>
          </ion-card-header>

          <ion-card-content>
            Keep close to Nature's heart... and break clear away, once in awhile, and climb a mountain or spend a week
            in the woods. Wash your spirit clean.
          </ion-card-content>
        </ion-card>
      `, config);
      const card = page.locator('ion-card');
      await expect(card).toHaveScreenshot(screenshot(`card-scale`));
    });
  });
});
