import React, { CSSProperties } from 'react';
export type Height = 'auto' | number | `${number}%`;
type AnimationStateClasses = {
    animating: string;
    animatingUp: string;
    animatingDown: string;
    animatingToHeightZero: string;
    animatingToHeightAuto: string;
    animatingToHeightSpecific: string;
    static: string;
    staticHeightZero: string;
    staticHeightAuto: string;
    staticHeightSpecific: string;
};
type OmitCSSProperties = 'display' | 'height';
export interface AnimateHeightProps extends React.HTMLAttributes<HTMLDivElement> {
    animateOpacity?: boolean;
    animationStateClasses?: AnimationStateClasses;
    applyInlineTransitions?: boolean;
    contentClassName?: string;
    contentRef?: React.MutableRefObject<HTMLDivElement | null>;
    delay?: number;
    duration?: number;
    easing?: string;
    height: Height;
    onHeightAnimationEnd?: (newHeight: Height) => any;
    onHeightAnimationStart?: (newHeight: Height) => any;
    style?: Omit<CSSProperties, OmitCSSProperties>;
}
declare const AnimateHeight: React.ForwardRefExoticComponent<AnimateHeightProps & React.RefAttributes<HTMLDivElement>>;
export default AnimateHeight;
