<!-- Please do not edit this file. Edit the `blah` field in the `package.json` instead. If in doubt, open an issue. -->


















# parse-url

 [![Support me on Patreon][badge_patreon]][patreon] [![Buy me a book][badge_amazon]][amazon] [![PayPal][badge_paypal_donate]][paypal-donations] [![Ask me anything](https://img.shields.io/badge/ask%20me-anything-1abc9c.svg)](https://github.com/IonicaBizau/ama) [![Version](https://img.shields.io/npm/v/parse-url.svg)](https://www.npmjs.com/package/parse-url) [![Downloads](https://img.shields.io/npm/dt/parse-url.svg)](https://www.npmjs.com/package/parse-url) [![Get help on Codementor](https://cdn.codementor.io/badges/get_help_github.svg)](https://www.codementor.io/johnnyb?utm_source=github&utm_medium=button&utm_term=johnnyb&utm_campaign=github)

<a href="https://www.buymeacoffee.com/H96WwChMy" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/yellow_img.png" alt="Buy Me A Coffee"></a>







> An advanced url parser supporting git urls too.






For low-level path parsing, check out [`parse-path`](https://github.com/IonicaBizau/parse-path). This very module is designed to parse urls. By default the urls are normalized.












## :cloud: Installation

```sh
# Using npm
npm install --save parse-url

# Using yarn
yarn add parse-url
```













## :clipboard: Example



```js
// Dependencies
import parseUrl from "../lib/index.js";

console.log(parseUrl("http://ionicabizau.net/blog"))
// {
//   protocols: [ 'http' ],
//   protocol: 'http',
//   port: '',
//   resource: 'ionicabizau.net',
//   user: '',
//   password: '',
//   pathname: '/blog',
//   hash: '',
//   search: '',
//   href: 'http://ionicabizau.net/blog',
//   query: {}
// }

console.log(parseUrl("http://domain.com/path/name?foo=bar&bar=42#some-hash"))
// {
//   protocols: [ 'http' ],
//   protocol: 'http',
//   port: '',
//   resource: 'domain.com',
//   user: '',
//   password: '',
//   pathname: '/path/name',
//   hash: 'some-hash',
//   search: 'foo=bar&bar=42',
//   href: 'http://domain.com/path/name?foo=bar&bar=42#some-hash',
//   query: { foo: 'bar', bar: '42' }
// }

// If you want to parse fancy Git urls, turn off the automatic url normalization
console.log(parseUrl("git+ssh://git@host.xz/path/name.git", false))
// {
//   protocols: [ 'git', 'ssh' ],
//   protocol: 'git',
//   port: '',
//   resource: 'host.xz',
//   user: 'git',
//   password: '',
//   pathname: '/path/name.git',
//   hash: '',
//   search: '',
//   href: 'git+ssh://git@host.xz/path/name.git',
//   query: {}
// }

console.log(parseUrl("git@github.com:IonicaBizau/git-stats.git", false))
// {
//   protocols: [ 'ssh' ],
//   protocol: 'ssh',
//   port: '',
//   resource: 'github.com',
//   user: 'git',
//   password: '',
//   pathname: '/IonicaBizau/git-stats.git',
//   hash: '',
//   search: '',
//   href: 'git@github.com:IonicaBizau/git-stats.git',
//   query: {}
// }
```











## :question: Get Help

There are few ways to get help:



 1. Please [post questions on Stack Overflow](https://stackoverflow.com/questions/ask). You can open issues with questions, as long you add a link to your Stack Overflow question.
 2. For bug reports and feature requests, open issues. :bug:
 3. For direct and quick help, you can [use Codementor](https://www.codementor.io/johnnyb). :rocket:





## :memo: Documentation


### `interopDefaultLegacy()`
#__PURE__

### `parseUrl(url, normalize)`
Parses the input url.

**Note**: This *throws* if invalid urls are provided.

#### Params

- **String** `url`: The input url.
- **Boolean|Object** `normalize`: Whether to normalize the url or not.                         Default is `false`. If `true`, the url will
                        be normalized. If an object, it will be the
                        options object sent to [`normalize-url`](https://github.com/sindresorhus/normalize-url).

                        For SSH urls, normalize won't work.

#### Return
- **Object** An object containing the following fields:
   - `protocols` (Array): An array with the url protocols (usually it has one element).
   - `protocol` (String): The first protocol, `"ssh"` (if the url is a ssh url) or `"file"`.
   - `port` (null|Number): The domain port.
   - `resource` (String): The url domain (including subdomains).
   - `user` (String): The authentication user (usually for ssh urls).
   - `pathname` (String): The url pathname.
   - `hash` (String): The url hash.
   - `search` (String): The url querystring value.
   - `href` (String): The input url.
   - `query` (Object): The url querystring, parsed as object.
   - `parse_failed` (Boolean): Whether the parsing failed or not.














## :yum: How to contribute
Have an idea? Found a bug? See [how to contribute][contributing].


## :sparkling_heart: Support my projects
I open-source almost everything I can, and I try to reply to everyone needing help using these projects. Obviously,
this takes time. You can integrate and use these projects in your applications *for free*! You can even change the source code and redistribute (even resell it).

However, if you get some profit from this or just want to encourage me to continue creating stuff, there are few ways you can do it:


 - Starring and sharing the projects you like :rocket:
 - [![Buy me a book][badge_amazon]][amazon]—I love books! I will remember you after years if you buy me one. :grin: :book:
 - [![PayPal][badge_paypal]][paypal-donations]—You can make one-time donations via PayPal. I'll probably buy a ~~coffee~~ tea. :tea:
 - [![Support me on Patreon][badge_patreon]][patreon]—Set up a recurring monthly donation and you will get interesting news about what I'm doing (things that I don't share with everyone).
 - **Bitcoin**—You can send me bitcoins at this address (or scanning the code below): `1P9BRsmazNQcuyTxEqveUsnf5CERdq35V6`

    ![](https://i.imgur.com/z6OQI95.png)


Thanks! :heart:
















## :dizzy: Where is this library used?
If you are using this library in one of your projects, add it in this list. :sparkles:

 - `git-up`
 - `@semantic-release/gitlab`
 - `lien`
 - `stun`
 - `@open-wa/wa-automate`
 - `kakapo`
 - `parse-db-uri`
 - `fuge-runner`
 - `url-local`
 - `build-plugin-ssr`
 - `rucksack`
 - `egg-muc-custom-loader`
 - `hologit`
 - `@enkeledi/react-native-week-month-date-picker`
 - `normalize-ssh`
 - `robots-agent`
 - `warp-api`
 - `normalize-id`
 - `xl-git-up`
 - `warp-server`
 - `@hemith/react-native-tnk`
 - `@kriblet/wa-automate`
 - `@notnuzzel/crawl`
 - `gitlab-backup-util-harduino`
 - `miguelcostero-ng2-toasty`
 - `native-kakao-login`
 - `npm_one_1_2_3`
 - `react-native-biometric-authenticate`
 - `react-native-arunmeena1987`
 - `react-native-contact-list`
 - `react-native-payu-payment-testing`
 - `react-native-is7`
 - `react-native-my-first-try-arun-ramya`
 - `react-native-kakao-maps`
 - `react-native-ytximkit`
 - `rn-adyen-dropin`
 - `begg`
 - `@positionex/position-sdk`
 - `@corelmax/react-native-my2c2p-sdk`
 - `@felipesimmi/react-native-datalogic-module`
 - `@hawkingnetwork/react-native-tab-view`
 - `@jprustv/sulla-hotfix`
 - `@mergulhao/wa-automate`
 - `cli-live-tutorial`
 - `drowl-base-theme-iconset`
 - `native-apple-login`
 - `react-native-cplus`
 - `npm_qwerty`
 - `vrt-cli`
 - `vue-cli-plugin-ice-builder`
 - `react-native-arunjeyam1987`
 - `soajs.repositories`
 - `ssh-host-manager`
 - `native-zip`
 - `graphmilker`
 - `react-native-bubble-chart`
 - `verify-aws-sns-signature`
 - `@dataparty/api`
 - `react-native-flyy`
 - `@react-18-pdf/root`
 - `@apardellass/react-native-audio-stream`
 - `@geeky-apo/react-native-advanced-clipboard`
 - `@hsui/plugin-wss`
 - `blitzzz`
 - `candlelabssdk`
 - `@roshub/api`
 - `@saad27/react-native-bottom-tab-tour`
 - `generator-bootstrap-boilerplate-template`
 - `npm_one_12_34_1_`
 - `npm_one_2_2`
 - `payutesting`
 - `react-native-responsive-size`
 - `vue-cli-plugin-ut-builder`
 - `xbuilder-forms`
 - `deploy-versioning`
 - `eval-spider`
 - `homebridge-pushcutter`
 - `@con-test/react-native-concent-common`
 - `tumblr-text`
 - `react-native-shekhar-bridge-test`
 - `loast`
 - `react-feedback-sdk`
 - `@oiti/documentoscopy-react-native`
 - `@snyk/sweater-comb`
 - `@angga30prabu/wa-modified`
 - `@hstech/utils`
 - `birken-react-native-community-image-editor`
 - `get-tarball-cli`
 - `luojia-cli-dev`
 - `reac-native-arun-ramya-test`
 - `react-native-plugpag-wrapper`
 - `react-native-pulsator-native`
 - `react-native-arun-ramya-test`
 - `react-native-arunramya151`
 - `react-native-transtracker-library`
 - `workpad`
 - `delta-screen`
 - `microbe.js`
 - `ndla-source-map-resolver`
 - `@jfilipe-sparta/react-native-module_2`
 - `cogoportutils`
 - `@lakutata-module/service`
 - `@buganto/client`
 - `@mockswitch/cli`
 - `angularvezba`
 - `api-reach-react-native-fix`
 - `react-native-syan-photo-picker`
 - `@wecraftapps/react-native-use-keyboard`
 - `hui-plugin-wss`
 - `l2forlerna`
 - `native-google-login`
 - `raact-native-arunramya151`
 - `react-native-modal-progress-bar`
 - `react-native-test-module-hhh`
 - `react-native-jsi-device-info`
 - `react-native-badge-control`
 - `wander-cli`
 - `heroku-wp-environment-sync`
 - `hubot-will-it-connect`
 - `normalize-ssh-url`
 - `ba-js-cookie-banner`
 - `ts-scraper`
 - `electron-info`
 - `rn-tm-notify`
 - `native-date-picker-module`
 - `@ndla/source-map-resolver`
 - `@jimengio/mocked-proxy`











## :scroll: License

[MIT][license] © [Ionică Bizău][website]






[license]: /LICENSE
[website]: https://ionicabizau.net
[contributing]: /CONTRIBUTING.md
[docs]: /DOCUMENTATION.md
[badge_patreon]: https://ionicabizau.github.io/badges/patreon.svg
[badge_amazon]: https://ionicabizau.github.io/badges/amazon.svg
[badge_paypal]: https://ionicabizau.github.io/badges/paypal.svg
[badge_paypal_donate]: https://ionicabizau.github.io/badges/paypal_donate.svg
[patreon]: https://www.patreon.com/ionicabizau
[amazon]: http://amzn.eu/hRo9sIZ
[paypal-donations]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RVXDDLKKLQRJW
