import fetch from "cross-fetch";
import { AddAdmin } from "./types/AddAdmin";
import { AddAdminResponse } from "./types/AddAdminResponse";
import { AddModToCommunity } from "./types/AddModToCommunity";
import { AddModToCommunityResponse } from "./types/AddModToCommunityResponse";
import { ApproveRegistrationApplication } from "./types/ApproveRegistrationApplication";
import { BanFromCommunity } from "./types/BanFromCommunity";
import { BanFromCommunityResponse } from "./types/BanFromCommunityResponse";
import { BanPerson } from "./types/BanPerson";
import { BanPersonResponse } from "./types/BanPersonResponse";
import { BannedPersonsResponse } from "./types/BannedPersonsResponse";
import { BlockCommunity } from "./types/BlockCommunity";
import { BlockCommunityResponse } from "./types/BlockCommunityResponse";
import { BlockPerson } from "./types/BlockPerson";
import { BlockPersonResponse } from "./types/BlockPersonResponse";
import { ChangePassword } from "./types/ChangePassword";
import { CommentReplyResponse } from "./types/CommentReplyResponse";
import { CommentReportResponse } from "./types/CommentReportResponse";
import { CommentResponse } from "./types/CommentResponse";
import { CommunityResponse } from "./types/CommunityResponse";
import { CreateComment } from "./types/CreateComment";
import { CreateCommentLike } from "./types/CreateCommentLike";
import { CreateCommentReport } from "./types/CreateCommentReport";
import { CreateCommunity } from "./types/CreateCommunity";
import { CreateCustomEmoji } from "./types/CreateCustomEmoji";
import { CreatePost } from "./types/CreatePost";
import { CreatePostLike } from "./types/CreatePostLike";
import { CreatePostReport } from "./types/CreatePostReport";
import { CreatePrivateMessage } from "./types/CreatePrivateMessage";
import { CreatePrivateMessageReport } from "./types/CreatePrivateMessageReport";
import { CreateSite } from "./types/CreateSite";
import { CustomEmojiResponse } from "./types/CustomEmojiResponse";
import { DeleteAccount } from "./types/DeleteAccount";
import { DeleteComment } from "./types/DeleteComment";
import { DeleteCommunity } from "./types/DeleteCommunity";
import { DeleteCustomEmoji } from "./types/DeleteCustomEmoji";
import { DeleteCustomEmojiResponse } from "./types/DeleteCustomEmojiResponse";
import { DeletePost } from "./types/DeletePost";
import { DeletePrivateMessage } from "./types/DeletePrivateMessage";
import { DistinguishComment } from "./types/DistinguishComment";
import { EditComment } from "./types/EditComment";
import { EditCommunity } from "./types/EditCommunity";
import { EditCustomEmoji } from "./types/EditCustomEmoji";
import { EditPost } from "./types/EditPost";
import { EditPrivateMessage } from "./types/EditPrivateMessage";
import { EditSite } from "./types/EditSite";
import { FeaturePost } from "./types/FeaturePost";
import { FollowCommunity } from "./types/FollowCommunity";
import { GetBannedPersons } from "./types/GetBannedPersons";
import { GetCaptcha } from "./types/GetCaptcha";
import { GetCaptchaResponse } from "./types/GetCaptchaResponse";
import { GetComment } from "./types/GetComment";
import { GetComments } from "./types/GetComments";
import { GetCommentsResponse } from "./types/GetCommentsResponse";
import { GetCommunity } from "./types/GetCommunity";
import { GetCommunityResponse } from "./types/GetCommunityResponse";
import { GetFederatedInstances } from "./types/GetFederatedInstances";
import { GetFederatedInstancesResponse } from "./types/GetFederatedInstancesResponse";
import { GetModlog } from "./types/GetModlog";
import { GetModlogResponse } from "./types/GetModlogResponse";
import { GetPersonDetails } from "./types/GetPersonDetails";
import { GetPersonDetailsResponse } from "./types/GetPersonDetailsResponse";
import { GetPersonMentions } from "./types/GetPersonMentions";
import { GetPersonMentionsResponse } from "./types/GetPersonMentionsResponse";
import { GetPost } from "./types/GetPost";
import { GetPostResponse } from "./types/GetPostResponse";
import { GetPosts } from "./types/GetPosts";
import { GetPostsResponse } from "./types/GetPostsResponse";
import { GetPrivateMessages } from "./types/GetPrivateMessages";
import { GetReplies } from "./types/GetReplies";
import { GetRepliesResponse } from "./types/GetRepliesResponse";
import { GetReportCount } from "./types/GetReportCount";
import { GetReportCountResponse } from "./types/GetReportCountResponse";
import { GetSite } from "./types/GetSite";
import { GetSiteMetadata } from "./types/GetSiteMetadata";
import { GetSiteMetadataResponse } from "./types/GetSiteMetadataResponse";
import { GetSiteResponse } from "./types/GetSiteResponse";
import { GetUnreadCount } from "./types/GetUnreadCount";
import { GetUnreadCountResponse } from "./types/GetUnreadCountResponse";
import { GetUnreadRegistrationApplicationCount } from "./types/GetUnreadRegistrationApplicationCount";
import { GetUnreadRegistrationApplicationCountResponse } from "./types/GetUnreadRegistrationApplicationCountResponse";
import { LeaveAdmin } from "./types/LeaveAdmin";
import { ListCommentReports } from "./types/ListCommentReports";
import { ListCommentReportsResponse } from "./types/ListCommentReportsResponse";
import { ListCommunities } from "./types/ListCommunities";
import { ListCommunitiesResponse } from "./types/ListCommunitiesResponse";
import { ListPostReports } from "./types/ListPostReports";
import { ListPostReportsResponse } from "./types/ListPostReportsResponse";
import { ListPrivateMessageReports } from "./types/ListPrivateMessageReports";
import { ListPrivateMessageReportsResponse } from "./types/ListPrivateMessageReportsResponse";
import { ListRegistrationApplications } from "./types/ListRegistrationApplications";
import { ListRegistrationApplicationsResponse } from "./types/ListRegistrationApplicationsResponse";
import { LockPost } from "./types/LockPost";
import { Login } from "./types/Login";
import { LoginResponse } from "./types/LoginResponse";
import { MarkAllAsRead } from "./types/MarkAllAsRead";
import { MarkCommentReplyAsRead } from "./types/MarkCommentReplyAsRead";
import { MarkPersonMentionAsRead } from "./types/MarkPersonMentionAsRead";
import { MarkPostAsRead } from "./types/MarkPostAsRead";
import { MarkPrivateMessageAsRead } from "./types/MarkPrivateMessageAsRead";
import { PasswordChangeAfterReset } from "./types/PasswordChangeAfterReset";
import { PasswordReset } from "./types/PasswordReset";
import { PersonMentionResponse } from "./types/PersonMentionResponse";
import { PostReportResponse } from "./types/PostReportResponse";
import { PostResponse } from "./types/PostResponse";
import { PrivateMessageReportResponse } from "./types/PrivateMessageReportResponse";
import { PrivateMessageResponse } from "./types/PrivateMessageResponse";
import { PrivateMessagesResponse } from "./types/PrivateMessagesResponse";
import { PurgeComment } from "./types/PurgeComment";
import { PurgeCommunity } from "./types/PurgeCommunity";
import { PurgeItemResponse } from "./types/PurgeItemResponse";
import { PurgePerson } from "./types/PurgePerson";
import { PurgePost } from "./types/PurgePost";
import { Register } from "./types/Register";
import { RegistrationApplicationResponse } from "./types/RegistrationApplicationResponse";
import { RemoveComment } from "./types/RemoveComment";
import { RemoveCommunity } from "./types/RemoveCommunity";
import { RemovePost } from "./types/RemovePost";
import { ResolveCommentReport } from "./types/ResolveCommentReport";
import { ResolveObject } from "./types/ResolveObject";
import { ResolveObjectResponse } from "./types/ResolveObjectResponse";
import { ResolvePostReport } from "./types/ResolvePostReport";
import { ResolvePrivateMessageReport } from "./types/ResolvePrivateMessageReport";
import { SaveComment } from "./types/SaveComment";
import { SavePost } from "./types/SavePost";
import { SaveUserSettings } from "./types/SaveUserSettings";
import { Search } from "./types/Search";
import { SearchResponse } from "./types/SearchResponse";
import { SiteResponse } from "./types/SiteResponse";
import { TransferCommunity } from "./types/TransferCommunity";
import { VerifyEmail } from "./types/VerifyEmail";
import { UploadImage, UploadImageResponse } from "./types/others";
/**
 * Helps build lemmy HTTP requests.
 */
export declare class LemmyHttp {
    #private;
    /**
     * Generates a new instance of LemmyHttp.
     * @param baseUrl the base url, without the vX version: https://lemmy.ml -> goes to https://lemmy.ml/api/vX
     * @param headers optional headers. Should contain `x-real-ip` and `x-forwarded-for` .
     */
    constructor(baseUrl: string, options?: {
        fetchFunction: typeof fetch;
        headers?: {
            [key: string]: string;
        };
    });
    /**
     * Gets the site, and your user data.
     *
     * `HTTP.GET /site`
     */
    getSite(form: GetSite): Promise<GetSiteResponse>;
    /**
     * Create your site.
     *
     * `HTTP.POST /site`
     */
    createSite(form: CreateSite): Promise<SiteResponse>;
    /**
     * Edit your site.
     *
     * `HTTP.PUT /site`
     */
    editSite(form: EditSite): Promise<SiteResponse>;
    /**
     * Leave the Site admins.
     *
     * `HTTP.POST /user/leave_admin`
     */
    leaveAdmin(form: LeaveAdmin): Promise<GetSiteResponse>;
    /**
     * Get the modlog.
     *
     * `HTTP.GET /modlog`
     */
    getModlog(form: GetModlog): Promise<GetModlogResponse>;
    /**
     * Search lemmy.
     *
     * `HTTP.GET /search`
     */
    search(form: Search): Promise<SearchResponse>;
    /**
     * Fetch a non-local / federated object.
     *
     * `HTTP.GET /resolve_object`
     */
    resolveObject(form: ResolveObject): Promise<ResolveObjectResponse>;
    /**
     * Create a new community.
     *
     * `HTTP.POST /community`
     */
    createCommunity(form: CreateCommunity): Promise<CommunityResponse>;
    /**
     * Get / fetch a community.
     *
     * `HTTP.GET /community`
     */
    getCommunity(form: GetCommunity): Promise<GetCommunityResponse>;
    /**
     * Edit a community.
     *
     * `HTTP.PUT /community`
     */
    editCommunity(form: EditCommunity): Promise<CommunityResponse>;
    /**
     * List communities, with various filters.
     *
     * `HTTP.GET /community/list`
     */
    listCommunities(form: ListCommunities): Promise<ListCommunitiesResponse>;
    /**
     * Follow / subscribe to a community.
     *
     * `HTTP.POST /community/follow`
     */
    followCommunity(form: FollowCommunity): Promise<CommunityResponse>;
    /**
     * Block a community.
     *
     * `HTTP.POST /community/block`
     */
    blockCommunity(form: BlockCommunity): Promise<BlockCommunityResponse>;
    /**
     * Delete a community.
     *
     * `HTTP.POST /community/delete`
     */
    deleteCommunity(form: DeleteCommunity): Promise<CommunityResponse>;
    /**
     * A moderator remove for a community.
     *
     * `HTTP.POST /community/remove`
     */
    removeCommunity(form: RemoveCommunity): Promise<CommunityResponse>;
    /**
     * Transfer your community to an existing moderator.
     *
     * `HTTP.POST /community/transfer`
     */
    transferCommunity(form: TransferCommunity): Promise<GetCommunityResponse>;
    /**
     * Ban a user from a community.
     *
     * `HTTP.POST /community/ban_user`
     */
    banFromCommunity(form: BanFromCommunity): Promise<BanFromCommunityResponse>;
    /**
     * Add a moderator to your community.
     *
     * `HTTP.POST /community/mod`
     */
    addModToCommunity(form: AddModToCommunity): Promise<AddModToCommunityResponse>;
    /**
     * Create a post.
     *
     * `HTTP.POST /post`
     */
    createPost(form: CreatePost): Promise<PostResponse>;
    /**
     * Get / fetch a post.
     *
     * `HTTP.GET /post`
     */
    getPost(form: GetPost): Promise<GetPostResponse>;
    /**
     * Edit a post.
     *
     * `HTTP.PUT /post`
     */
    editPost(form: EditPost): Promise<PostResponse>;
    /**
     * Delete a post.
     *
     * `HTTP.POST /post/delete`
     */
    deletePost(form: DeletePost): Promise<PostResponse>;
    /**
     * A moderator remove for a post.
     *
     * `HTTP.POST /post/remove`
     */
    removePost(form: RemovePost): Promise<PostResponse>;
    /**
     * Mark a post as read.
     *
     * `HTTP.POST /post/mark_as_read`
     */
    markPostAsRead(form: MarkPostAsRead): Promise<PostResponse>;
    /**
     * A moderator can lock a post ( IE disable new comments ).
     *
     * `HTTP.POST /post/lock`
     */
    lockPost(form: LockPost): Promise<PostResponse>;
    /**
     * A moderator can feature a community post ( IE stick it to the top of a community ).
     *
     * `HTTP.POST /post/feature`
     */
    featurePost(form: FeaturePost): Promise<PostResponse>;
    /**
     * Get / fetch posts, with various filters.
     *
     * `HTTP.GET /post/list`
     */
    getPosts(form: GetPosts): Promise<GetPostsResponse>;
    /**
     * Like / vote on a post.
     *
     * `HTTP.POST /post/like`
     */
    likePost(form: CreatePostLike): Promise<PostResponse>;
    /**
     * Save a post.
     *
     * `HTTP.PUT /post/save`
     */
    savePost(form: SavePost): Promise<PostResponse>;
    /**
     * Report a post.
     *
     * `HTTP.POST /post/report`
     */
    createPostReport(form: CreatePostReport): Promise<PostReportResponse>;
    /**
     * Resolve a post report. Only a mod can do this.
     *
     * `HTTP.PUT /post/report/resolve`
     */
    resolvePostReport(form: ResolvePostReport): Promise<PostReportResponse>;
    /**
     * List post reports.
     *
     * `HTTP.GET /post/report/list`
     */
    listPostReports(form: ListPostReports): Promise<ListPostReportsResponse>;
    /**
     * Fetch metadata for any given site.
     *
     * `HTTP.GET /post/site_metadata`
     */
    getSiteMetadata(form: GetSiteMetadata): Promise<GetSiteMetadataResponse>;
    /**
     * Create a comment.
     *
     * `HTTP.POST /comment`
     */
    createComment(form: CreateComment): Promise<CommentResponse>;
    /**
     * Edit a comment.
     *
     * `HTTP.PUT /comment`
     */
    editComment(form: EditComment): Promise<CommentResponse>;
    /**
     * Delete a comment.
     *
     * `HTTP.POST /comment/delete`
     */
    deleteComment(form: DeleteComment): Promise<CommentResponse>;
    /**
     * A moderator remove for a comment.
     *
     * `HTTP.POST /comment/remove`
     */
    removeComment(form: RemoveComment): Promise<CommentResponse>;
    /**
     * Mark a comment as read.
     *
     * `HTTP.POST /comment/mark_as_read`
     */
    markCommentReplyAsRead(form: MarkCommentReplyAsRead): Promise<CommentReplyResponse>;
    /**
     * Like / vote on a comment.
     *
     * `HTTP.POST /comment/like`
     */
    likeComment(form: CreateCommentLike): Promise<CommentResponse>;
    /**
     * Save a comment.
     *
     * `HTTP.PUT /comment/save`
     */
    saveComment(form: SaveComment): Promise<CommentResponse>;
    /**
     * Distinguishes a comment (speak as moderator)
     *
     * `HTTP.POST /comment/distinguish`
     */
    distinguishComment(form: DistinguishComment): Promise<CommentResponse>;
    /**
     * Get / fetch comments.
     *
     * `HTTP.GET /comment/list`
     */
    getComments(form: GetComments): Promise<GetCommentsResponse>;
    /**
     * Get / fetch comment.
     *
     * `HTTP.GET /comment`
     */
    getComment(form: GetComment): Promise<CommentResponse>;
    /**
     * Report a comment.
     *
     * `HTTP.POST /comment/report`
     */
    createCommentReport(form: CreateCommentReport): Promise<CommentReportResponse>;
    /**
     * Resolve a comment report. Only a mod can do this.
     *
     * `HTTP.PUT /comment/report/resolve`
     */
    resolveCommentReport(form: ResolveCommentReport): Promise<CommentReportResponse>;
    /**
     * List comment reports.
     *
     * `HTTP.GET /comment/report/list`
     */
    listCommentReports(form: ListCommentReports): Promise<ListCommentReportsResponse>;
    /**
     * Get / fetch private messages.
     *
     * `HTTP.GET /private_message/list`
     */
    getPrivateMessages(form: GetPrivateMessages): Promise<PrivateMessagesResponse>;
    /**
     * Create a private message.
     *
     * `HTTP.POST /private_message`
     */
    createPrivateMessage(form: CreatePrivateMessage): Promise<PrivateMessageResponse>;
    /**
     * Edit a private message.
     *
     * `HTTP.PUT /private_message`
     */
    editPrivateMessage(form: EditPrivateMessage): Promise<PrivateMessageResponse>;
    /**
     * Delete a private message.
     *
     * `HTTP.POST /private_message/delete`
     */
    deletePrivateMessage(form: DeletePrivateMessage): Promise<PrivateMessageResponse>;
    /**
     * Mark a private message as read.
     *
     * `HTTP.POST /private_message/mark_as_read`
     */
    markPrivateMessageAsRead(form: MarkPrivateMessageAsRead): Promise<PrivateMessageResponse>;
    /**
     * Create a report for a private message.
     *
     * `HTTP.POST /private_message/report`
     */
    createPrivateMessageReport(form: CreatePrivateMessageReport): Promise<PrivateMessageReportResponse>;
    /**
     * Resolve a report for a private message.
     *
     * `HTTP.PUT /private_message/report/resolve`
     */
    resolvePrivateMessageReport(form: ResolvePrivateMessageReport): Promise<PrivateMessageReportResponse>;
    /**
     * List private message reports.
     *
     * `HTTP.GET /private_message/report/list`
     */
    listPrivateMessageReports(form: ListPrivateMessageReports): Promise<ListPrivateMessageReportsResponse>;
    /**
     * Register a new user.
     *
     * `HTTP.POST /user/register`
     */
    register(form: Register): Promise<LoginResponse>;
    /**
     * Log into lemmy.
     *
     * `HTTP.POST /user/login`
     */
    login(form: Login): Promise<LoginResponse>;
    /**
     * Get the details for a person.
     *
     * `HTTP.GET /user`
     */
    getPersonDetails(form: GetPersonDetails): Promise<GetPersonDetailsResponse>;
    /**
     * Get mentions for your user.
     *
     * `HTTP.GET /user/mention`
     */
    getPersonMentions(form: GetPersonMentions): Promise<GetPersonMentionsResponse>;
    /**
     * Mark a person mention as read.
     *
     * `HTTP.POST /user/mention/mark_as_read`
     */
    markPersonMentionAsRead(form: MarkPersonMentionAsRead): Promise<PersonMentionResponse>;
    /**
     * Get comment replies.
     *
     * `HTTP.GET /user/replies`
     */
    getReplies(form: GetReplies): Promise<GetRepliesResponse>;
    /**
     * Ban a person from your site.
     *
     * `HTTP.POST /user/ban`
     */
    banPerson(form: BanPerson): Promise<BanPersonResponse>;
    /**
     * Get a list of banned users
     *
     * `HTTP.GET /user/banned`
     */
    getBannedPersons(form: GetBannedPersons): Promise<BannedPersonsResponse>;
    /**
     * Block a person.
     *
     * `HTTP.POST /user/block`
     */
    blockPerson(form: BlockPerson): Promise<BlockPersonResponse>;
    /**
     * Fetch a Captcha.
     *
     * `HTTP.GET /user/get_captcha`
     */
    getCaptcha(form: GetCaptcha): Promise<GetCaptchaResponse>;
    /**
     * Delete your account.
     *
     * `HTTP.POST /user/delete_account`
     */
    deleteAccount(form: DeleteAccount): Promise<null>;
    /**
     * Reset your password.
     *
     * `HTTP.POST /user/password_reset`
     */
    passwordReset(form: PasswordReset): Promise<null>;
    /**
     * Change your password from an email / token based reset.
     *
     * `HTTP.POST /user/password_change`
     */
    passwordChangeAfterReset(form: PasswordChangeAfterReset): Promise<LoginResponse>;
    /**
     * Mark all replies as read.
     *
     * `HTTP.POST /user/mark_all_as_read`
     */
    markAllAsRead(form: MarkAllAsRead): Promise<GetRepliesResponse>;
    /**
     * Save your user settings.
     *
     * `HTTP.PUT /user/save_user_settings`
     */
    saveUserSettings(form: SaveUserSettings): Promise<LoginResponse>;
    /**
     * Change your user password.
     *
     * `HTTP.PUT /user/change_password`
     */
    changePassword(form: ChangePassword): Promise<LoginResponse>;
    /**
     * Get counts for your reports
     *
     * `HTTP.GET /user/report_count`
     */
    getReportCount(form: GetReportCount): Promise<GetReportCountResponse>;
    /**
     * Get your unread counts
     *
     * `HTTP.GET /user/unread_count`
     */
    getUnreadCount(form: GetUnreadCount): Promise<GetUnreadCountResponse>;
    /**
     * Verify your email
     *
     * `HTTP.POST /user/verify_email`
     */
    verifyEmail(form: VerifyEmail): Promise<null>;
    /**
     * Add an admin to your site.
     *
     * `HTTP.POST /admin/add`
     */
    addAdmin(form: AddAdmin): Promise<AddAdminResponse>;
    /**
     * Get the unread registration applications count.
     *
     * `HTTP.GET /admin/registration_application/count`
     */
    getUnreadRegistrationApplicationCount(form: GetUnreadRegistrationApplicationCount): Promise<GetUnreadRegistrationApplicationCountResponse>;
    /**
     * List the registration applications.
     *
     * `HTTP.GET /admin/registration_application/list`
     */
    listRegistrationApplications(form: ListRegistrationApplications): Promise<ListRegistrationApplicationsResponse>;
    /**
     * Approve a registration application
     *
     * `HTTP.PUT /admin/registration_application/approve`
     */
    approveRegistrationApplication(form: ApproveRegistrationApplication): Promise<RegistrationApplicationResponse>;
    /**
     * Purge / Delete a person from the database.
     *
     * `HTTP.POST /admin/purge/person`
     */
    purgePerson(form: PurgePerson): Promise<PurgeItemResponse>;
    /**
     * Purge / Delete a community from the database.
     *
     * `HTTP.POST /admin/purge/community`
     */
    purgeCommunity(form: PurgeCommunity): Promise<PurgeItemResponse>;
    /**
     * Purge / Delete a post from the database.
     *
     * `HTTP.POST /admin/purge/post`
     */
    purgePost(form: PurgePost): Promise<PurgeItemResponse>;
    /**
     * Purge / Delete a comment from the database.
     *
     * `HTTP.POST /admin/purge/comment`
     */
    purgeComment(form: PurgeComment): Promise<PurgeItemResponse>;
    /**
     * Create a new custom emoji
     *
     * `HTTP.POST /custom_emoji`
     */
    createCustomEmoji(form: CreateCustomEmoji): Promise<CustomEmojiResponse>;
    /**
     * Edit an existing custom emoji
     *
     * `HTTP.PUT /custom_emoji`
     */
    editCustomEmoji(form: EditCustomEmoji): Promise<CustomEmojiResponse>;
    /**
     * Delete a custom emoji
     *
     * `HTTP.Post /custom_emoji/delete`
     */
    deleteCustomEmoji(form: DeleteCustomEmoji): Promise<DeleteCustomEmojiResponse>;
    /**
     * Fetch federated instances.
     *
     * `HTTP.Get /federated_instances`
     */
    getFederatedInstances(form: GetFederatedInstances): Promise<GetFederatedInstancesResponse>;
    /**
     * Upload an image to the server.
     */
    uploadImage({ image, auth, }: UploadImage): Promise<UploadImageResponse>;
}
