"use strict";

// Dependencies

var parseUrl = require("parse-url"),
    isSsh = require("is-ssh");

/**
 * gitUp
 * Parses the input url.
 *
 * @name gitUp
 * @function
 * @param {String} input The input url.
 * @return {Object} An object containing the following fields:
 *
 *  - `protocols` (Array): An array with the url protocols (usually it has one element).
 *  - `port` (null|Number): The domain port.
 *  - `resource` (String): The url domain (including subdomains).
 *  - `user` (String): The authentication user (usually for ssh urls).
 *  - `pathname` (String): The url pathname.
 *  - `hash` (String): The url hash.
 *  - `search` (String): The url querystring value.
 *  - `href` (String): The input url.
 *  - `protocol` (String): The git url protocol.
 *  - `token` (String): The oauth token (could appear in the https urls).
 */
function gitUp(input) {
    var output = parseUrl(input);
    output.token = "";

    if (output.password === "x-oauth-basic") {
        output.token = output.user;
    } else if (output.user === "x-token-auth") {
        output.token = output.password;
    }

    if (isSsh(output.protocols) || output.protocols.length === 0 && isSsh(input)) {
        output.protocol = "ssh";
    } else if (output.protocols.length) {
        output.protocol = output.protocols[0];
    } else {
        output.protocol = "file";
        output.protocols = ["file"];
    }

    output.href = output.href.replace(/\/$/, "");
    return output;
}

module.exports = gitUp;