import type { AnimationBuilder } from '@ionic/core/components';
import React from 'react';
import type { IonRouterContextState } from '../components/IonRouterContext';
import type { NavContextState } from '../contexts/NavContext';
import type { RouteAction } from '../models/RouteAction';
import type { RouteInfo } from '../models/RouteInfo';
import type { RouterDirection } from '../models/RouterDirection';
import type { LocationHistory } from './LocationHistory';
import PageManager from './PageManager';
interface NavManagerProps {
    routeInfo: RouteInfo;
    onNativeBack: () => void;
    onNavigateBack: (route?: string | RouteInfo, animationBuilder?: AnimationBuilder) => void;
    onNavigate: (path: string, action: RouteAction, direction?: RouterDirection, animationBuilder?: AnimationBuilder, options?: any, tab?: string) => void;
    onSetCurrentTab: (tab: string, routeInfo: RouteInfo) => void;
    onChangeTab: (tab: string, path: string, routeOptions?: any) => void;
    onResetTab: (tab: string, path: string, routeOptions?: any) => void;
    ionRedirect: any;
    ionRoute: any;
    stackManager: any;
    locationHistory: LocationHistory;
}
export declare class NavManager extends React.PureComponent<NavManagerProps, NavContextState> {
    ionRouterContextValue: IonRouterContextState;
    constructor(props: NavManagerProps);
    componentDidMount(): void;
    componentWillUnmount(): void;
    handleHardwareBackButton(e: any): void;
    goBack(route?: string | RouteInfo, animationBuilder?: AnimationBuilder): void;
    nativeGoBack(): void;
    navigate(path: string, direction?: RouterDirection, action?: RouteAction, animationBuilder?: AnimationBuilder, options?: any, tab?: string): void;
    getPageManager(): typeof PageManager;
    getIonRedirect(): any;
    getIonRoute(): any;
    getStackManager(): any;
    render(): JSX.Element;
}
export {};
