import type { ToastOptions } from '@ionic/core/components';
import type { HookOverlayOptions } from './HookOverlayOptions';
/**
 * A hook for presenting/dismissing an IonToast component
 * @returns Returns the present and dismiss methods in an array
 */
export declare function useIonToast(): UseIonToastResult;
export type UseIonToastResult = [
    {
        /**
         * Presents the toast
         * @param message Message to be shown in the toast.
         * @param duration Optional - How many milliseconds to wait before hiding the toast. By default, it will show until dismissToast() is called.
         */
        (message: string, duration?: number): Promise<void>;
        /**
         * Presents the Toast
         * @param options The options to pass to the IonToast.
         */
        (options: ToastOptions & HookOverlayOptions): Promise<void>;
    },
    /**
     * Dismisses the toast
     */
    () => Promise<void>
];
