import type { PickerButton, PickerColumn, PickerOptions } from '@ionic/core/components';
import type { HookOverlayOptions } from './HookOverlayOptions';
/**
 * A hook for presenting/dismissing an IonPicker component
 * @returns Returns the present and dismiss methods in an array
 */
export declare function useIonPicker(): UseIonPickerResult;
export type UseIonPickerResult = [
    {
        /**
         * Presents the picker
         * @param columns Array of columns to be displayed in the picker.
         * @param buttons Optional - Array of buttons to be displayed at the top of the picker.
         */
        (columns: PickerColumn[], buttons?: PickerButton[]): Promise<void>;
        /**
         * Presents the picker
         * @param options The options to pass to the IonPicker
         */
        (options: PickerOptions & HookOverlayOptions): Promise<void>;
    },
    /**
     * Dismisses the picker
     */
    () => Promise<void>
];
